/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.adapter.method.jaxb;

import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.springframework.core.MethodParameter;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.adapter.method.jaxb.AbstractJaxb2PayloadMethodProcessor;

public class JaxbElementPayloadMethodProcessor
extends AbstractJaxb2PayloadMethodProcessor {
    @Override
    protected boolean supportsRequestPayloadParameter(MethodParameter parameter) {
        Class<?> parameterType = parameter.getParameterType();
        Type genericType = parameter.getGenericParameterType();
        return JAXBElement.class.equals(parameterType) && genericType instanceof ParameterizedType;
    }

    @Override
    public JAXBElement<?> resolveArgument(MessageContext messageContext, MethodParameter parameter) throws JAXBException {
        ParameterizedType parameterizedType = (ParameterizedType)parameter.getGenericParameterType();
        Class clazz = (Class)parameterizedType.getActualTypeArguments()[0];
        return this.unmarshalElementFromRequestPayload(messageContext, clazz);
    }

    @Override
    protected boolean supportsResponsePayloadReturnType(MethodParameter returnType) {
        Class<?> parameterType = returnType.getParameterType();
        return JAXBElement.class.isAssignableFrom(parameterType);
    }

    @Override
    protected void handleReturnValueInternal(MessageContext messageContext, MethodParameter returnType, Object returnValue) throws JAXBException {
        JAXBElement element = (JAXBElement)returnValue;
        this.marshalToResponsePayload(messageContext, element.getDeclaredType(), element);
    }
}

