/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.support;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import javax.xml.namespace.NamespaceContext;
import org.springframework.util.Assert;
import org.springframework.ws.server.endpoint.annotation.Namespace;
import org.springframework.ws.server.endpoint.annotation.Namespaces;
import org.springframework.xml.namespace.SimpleNamespaceContext;

public abstract class NamespaceUtils {
    private NamespaceUtils() {
    }

    public static NamespaceContext getNamespaceContext(Method method) {
        Assert.notNull((Object)method, "'method' must not be null");
        SimpleNamespaceContext namespaceContext = new SimpleNamespaceContext();
        Class<?> endpointClass = method.getDeclaringClass();
        Package endpointPackage = endpointClass.getPackage();
        if (endpointPackage != null) {
            NamespaceUtils.addNamespaceAnnotations(endpointPackage, namespaceContext);
        }
        NamespaceUtils.addNamespaceAnnotations(endpointClass, namespaceContext);
        NamespaceUtils.addNamespaceAnnotations(method, namespaceContext);
        return namespaceContext;
    }

    private static void addNamespaceAnnotations(AnnotatedElement annotatedElement, SimpleNamespaceContext namespaceContext) {
        if (annotatedElement.isAnnotationPresent(Namespaces.class)) {
            Namespaces namespacesAnn = annotatedElement.getAnnotation(Namespaces.class);
            for (Namespace namespaceAnn : namespacesAnn.value()) {
                namespaceContext.bindNamespaceUri(namespaceAnn.prefix(), namespaceAnn.uri());
            }
        }
        if (annotatedElement.isAnnotationPresent(Namespace.class)) {
            Namespace namespaceAnn = annotatedElement.getAnnotation(Namespace.class);
            namespaceContext.bindNamespaceUri(namespaceAnn.prefix(), namespaceAnn.uri());
        }
    }
}

