/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.saaj;

import jakarta.activation.DataHandler;
import jakarta.xml.soap.AttachmentPart;
import jakarta.xml.soap.SOAPException;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.util.Assert;
import org.springframework.ws.mime.Attachment;
import org.springframework.ws.soap.saaj.SaajAttachmentException;

class SaajAttachment
implements Attachment {
    private final AttachmentPart saajAttachment;

    public SaajAttachment(AttachmentPart saajAttachment) {
        Assert.notNull((Object)saajAttachment, "saajAttachment must not be null");
        this.saajAttachment = saajAttachment;
    }

    @Override
    public String getContentId() {
        return this.saajAttachment.getContentId();
    }

    @Override
    public String getContentType() {
        return this.saajAttachment.getContentType();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            return this.saajAttachment.getDataHandler().getInputStream();
        }
        catch (SOAPException ex) {
            throw new SaajAttachmentException(ex);
        }
    }

    @Override
    public long getSize() {
        try {
            return this.saajAttachment.getSize();
        }
        catch (SOAPException ex) {
            throw new SaajAttachmentException(ex);
        }
    }

    @Override
    public DataHandler getDataHandler() {
        try {
            return this.saajAttachment.getDataHandler();
        }
        catch (SOAPException ex) {
            throw new SaajAttachmentException(ex);
        }
    }
}

