/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.saaj;

import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPFault;
import java.util.Locale;
import javax.xml.namespace.QName;
import org.springframework.util.Assert;
import org.springframework.ws.soap.SoapVersion;
import org.springframework.ws.soap.saaj.SaajSoap11Fault;
import org.springframework.ws.soap.saaj.SaajSoapBody;
import org.springframework.ws.soap.saaj.SaajSoapFaultException;
import org.springframework.ws.soap.soap11.Soap11Body;
import org.springframework.ws.soap.soap11.Soap11Fault;

class SaajSoap11Body
extends SaajSoapBody
implements Soap11Body {
    private final boolean langAttributeOnSoap11FaultString;

    SaajSoap11Body(SOAPBody body2, boolean langAttributeOnSoap11FaultString) {
        super(body2);
        this.langAttributeOnSoap11FaultString = langAttributeOnSoap11FaultString;
    }

    @Override
    public Soap11Fault getFault() {
        SOAPFault fault = this.getSaajBody().getFault();
        return fault != null ? new SaajSoap11Fault(fault) : null;
    }

    @Override
    public Soap11Fault addFault(QName faultCode, String faultString, Locale faultStringLocale) {
        Assert.notNull((Object)faultCode, "No faultCode given");
        Assert.hasLength(faultString, "faultString cannot be empty");
        Assert.hasLength(faultCode.getLocalPart(), "faultCode's localPart cannot be empty");
        Assert.hasLength(faultCode.getNamespaceURI(), "faultCode's namespaceUri cannot be empty");
        if (!this.langAttributeOnSoap11FaultString) {
            faultStringLocale = null;
        }
        try {
            this.getSaajBody().removeContents();
            SOAPBody body2 = this.getSaajBody();
            SOAPFault result = faultStringLocale == null ? body2.addFault(faultCode, faultString) : body2.addFault(faultCode, faultString, faultStringLocale);
            SOAPFault saajFault = result;
            return new SaajSoap11Fault(saajFault);
        }
        catch (SOAPException ex) {
            throw new SaajSoapFaultException(ex);
        }
    }

    @Override
    public Soap11Fault addClientOrSenderFault(String faultString, Locale locale) {
        return this.addFault(SoapVersion.SOAP_11.getClientOrSenderFaultName(), faultString, locale);
    }

    @Override
    public Soap11Fault addMustUnderstandFault(String faultString, Locale locale) {
        return this.addFault(SoapVersion.SOAP_11.getMustUnderstandFaultName(), faultString, locale);
    }

    @Override
    public Soap11Fault addServerOrReceiverFault(String faultString, Locale locale) {
        return this.addFault(SoapVersion.SOAP_11.getServerOrReceiverFaultName(), faultString, locale);
    }

    @Override
    public Soap11Fault addVersionMismatchFault(String faultString, Locale locale) {
        return this.addFault(SoapVersion.SOAP_11.getVersionMismatchFaultName(), faultString, locale);
    }
}

