/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.http;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.time.Duration;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.ws.transport.WebServiceConnection;
import org.springframework.ws.transport.http.AbstractHttpWebServiceMessageSender;
import org.springframework.ws.transport.http.JdkHttpClientConnection;

public class JdkHttpClientMessageSender
extends AbstractHttpWebServiceMessageSender
implements InitializingBean {
    private static final Duration DEFAULT_CONNECTION_TIMEOUT = Duration.ofSeconds(60L);
    private static final Duration DEFAULT_REQUEST_TIMEOUT = Duration.ofSeconds(60L);
    private HttpClient httpClient;
    private Duration connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;
    private Duration requestTimeout = DEFAULT_REQUEST_TIMEOUT;

    public JdkHttpClientMessageSender() {
    }

    public JdkHttpClientMessageSender(HttpClient httpClient) {
        Assert.notNull((Object)httpClient, "httpClient must not be null");
        this.httpClient = httpClient;
    }

    public void setHttpClient(@Nullable HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void setConnectionTimeout(@Nullable Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setRequestTimeout(@Nullable Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    @Override
    public WebServiceConnection createConnection(URI uri) throws IOException {
        JdkHttpClientConnection connection = new JdkHttpClientConnection(this.httpClient, uri, this.requestTimeout);
        if (this.isAcceptGzipEncoding()) {
            connection.addRequestHeader("Accept-Encoding", "gzip");
        }
        return connection;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.httpClient == null) {
            this.httpClient = HttpClient.newBuilder().connectTimeout(this.connectionTimeout).build();
        }
    }
}

