/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.jms;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TextMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import org.springframework.jms.connection.ConnectionFactoryUtils;
import org.springframework.jms.core.MessagePostProcessor;
import org.springframework.jms.support.JmsUtils;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.transport.AbstractSenderConnection;
import org.springframework.ws.transport.jms.BytesMessageInputStream;
import org.springframework.ws.transport.jms.BytesMessageOutputStream;
import org.springframework.ws.transport.jms.JmsTransportException;
import org.springframework.ws.transport.jms.TextMessageInputStream;
import org.springframework.ws.transport.jms.TextMessageOutputStream;
import org.springframework.ws.transport.jms.support.JmsTransportUtils;

public class JmsSenderConnection
extends AbstractSenderConnection {
    private final ConnectionFactory connectionFactory;
    private final Connection connection;
    private final Session session;
    private final Destination requestDestination;
    private Message requestMessage;
    private Destination responseDestination;
    private Message responseMessage;
    private long receiveTimeout;
    private int deliveryMode;
    private long timeToLive;
    private int priority;
    private String textMessageEncoding;
    private MessagePostProcessor postProcessor;
    private boolean sessionTransacted = false;
    private boolean temporaryResponseQueueCreated = false;

    protected JmsSenderConnection(ConnectionFactory connectionFactory, Connection connection, Session session, Destination requestDestination, Message requestMessage) throws JMSException {
        Assert.notNull((Object)connectionFactory, "'connectionFactory' must not be null");
        Assert.notNull((Object)connection, "'connection' must not be null");
        Assert.notNull((Object)session, "'session' must not be null");
        Assert.notNull((Object)requestDestination, "'requestDestination' must not be null");
        Assert.notNull((Object)requestMessage, "'requestMessage' must not be null");
        this.connectionFactory = connectionFactory;
        this.connection = connection;
        this.session = session;
        this.requestDestination = requestDestination;
        this.requestMessage = requestMessage;
    }

    public Message getRequestMessage() {
        return this.requestMessage;
    }

    public Message getResponseMessage() {
        return this.responseMessage;
    }

    void setResponseDestination(Destination responseDestination) {
        this.responseDestination = responseDestination;
    }

    void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    void setDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    void setPriority(int priority) {
        this.priority = priority;
    }

    void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    void setTextMessageEncoding(String textMessageEncoding) {
        this.textMessageEncoding = textMessageEncoding;
    }

    void setPostProcessor(MessagePostProcessor postProcessor) {
        this.postProcessor = postProcessor;
    }

    void setSessionTransacted(boolean sessionTransacted) {
        this.sessionTransacted = sessionTransacted;
    }

    @Override
    public URI getUri() throws URISyntaxException {
        try {
            return JmsTransportUtils.toUri(this.requestDestination);
        }
        catch (JMSException ex) {
            throw new URISyntaxException("", ex.getMessage());
        }
    }

    @Override
    public boolean hasError() throws IOException {
        return false;
    }

    @Override
    public String getErrorMessage() throws IOException {
        return null;
    }

    @Override
    public void addRequestHeader(String name, String value) throws IOException {
        try {
            JmsTransportUtils.addHeader(this.requestMessage, name, value);
        }
        catch (JMSException ex) {
            throw new JmsTransportException("Could not set property", ex);
        }
    }

    @Override
    protected OutputStream getRequestOutputStream() throws IOException {
        if (this.requestMessage instanceof BytesMessage) {
            return new BytesMessageOutputStream((BytesMessage)this.requestMessage);
        }
        if (this.requestMessage instanceof TextMessage) {
            return new TextMessageOutputStream((TextMessage)this.requestMessage, this.textMessageEncoding);
        }
        throw new IllegalStateException("Unknown request message type [" + this.requestMessage + "]");
    }

    @Override
    protected void onSendAfterWrite(WebServiceMessage message) throws IOException {
        MessageProducer messageProducer = null;
        try {
            messageProducer = this.session.createProducer(this.requestDestination);
            messageProducer.setDeliveryMode(this.deliveryMode);
            messageProducer.setTimeToLive(this.timeToLive);
            messageProducer.setPriority(this.priority);
            if (this.responseDestination == null) {
                this.responseDestination = this.session.createTemporaryQueue();
                this.temporaryResponseQueueCreated = true;
            }
            this.requestMessage.setJMSReplyTo(this.responseDestination);
            if (this.postProcessor != null) {
                this.requestMessage = this.postProcessor.postProcessMessage(this.requestMessage);
            }
            this.connection.start();
            messageProducer.send(this.requestMessage);
            if (this.session.getTransacted() && this.isSessionLocallyTransacted(this.session)) {
                JmsUtils.commitIfNecessary(this.session);
            }
        }
        catch (JMSException ex) {
            try {
                throw new JmsTransportException(ex);
            }
            catch (Throwable throwable) {
                JmsUtils.closeMessageProducer(messageProducer);
                throw throwable;
            }
        }
        JmsUtils.closeMessageProducer(messageProducer);
    }

    private boolean isSessionLocallyTransacted(Session session) {
        return this.sessionTransacted && !ConnectionFactoryUtils.isSessionTransactional(session, this.connectionFactory);
    }

    @Override
    protected void onReceiveBeforeRead() throws IOException {
        MessageConsumer messageConsumer;
        block13: {
            messageConsumer = null;
            try {
                Message message;
                if (this.temporaryResponseQueueCreated) {
                    messageConsumer = this.session.createConsumer(this.responseDestination);
                } else {
                    String messageId = this.requestMessage.getJMSMessageID().replaceAll("'", "''");
                    String messageSelector = "JMSCorrelationID = '" + messageId + "'";
                    messageConsumer = this.session.createConsumer(this.responseDestination, messageSelector);
                }
                Message message2 = message = this.receiveTimeout >= 0L ? messageConsumer.receive(this.receiveTimeout) : messageConsumer.receive();
                if (message instanceof BytesMessage || message instanceof TextMessage) {
                    this.responseMessage = message;
                    break block13;
                }
                if (message == null) break block13;
                throw new IllegalArgumentException("Wrong message type: [" + message.getClass() + "]. Only BytesMessages or TextMessages can be handled.");
            }
            catch (JMSException ex) {
                try {
                    throw new JmsTransportException(ex);
                }
                catch (Throwable throwable) {
                    JmsUtils.closeMessageConsumer(messageConsumer);
                    if (this.temporaryResponseQueueCreated) {
                        try {
                            ((TemporaryQueue)this.responseDestination).delete();
                        }
                        catch (JMSException jMSException) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        }
        JmsUtils.closeMessageConsumer(messageConsumer);
        if (this.temporaryResponseQueueCreated) {
            try {
                ((TemporaryQueue)this.responseDestination).delete();
            }
            catch (JMSException message) {}
        }
    }

    @Override
    protected boolean hasResponse() throws IOException {
        return this.responseMessage != null;
    }

    @Override
    public Iterator<String> getResponseHeaderNames() throws IOException {
        try {
            return JmsTransportUtils.getHeaderNames(this.responseMessage);
        }
        catch (JMSException ex) {
            throw new JmsTransportException("Could not get property names", ex);
        }
    }

    @Override
    public Iterator<String> getResponseHeaders(String name) throws IOException {
        try {
            return JmsTransportUtils.getHeaders(this.responseMessage, name);
        }
        catch (JMSException ex) {
            throw new JmsTransportException("Could not get property value", ex);
        }
    }

    @Override
    protected InputStream getResponseInputStream() throws IOException {
        if (this.responseMessage instanceof BytesMessage) {
            return new BytesMessageInputStream((BytesMessage)this.responseMessage);
        }
        if (this.responseMessage instanceof TextMessage) {
            return new TextMessageInputStream((TextMessage)this.responseMessage, this.textMessageEncoding);
        }
        throw new IllegalStateException("Unknown response message type [" + this.responseMessage + "]");
    }

    @Override
    protected void onClose() throws IOException {
        JmsUtils.closeSession(this.session);
        ConnectionFactoryUtils.releaseConnection(this.connection, this.connectionFactory, true);
    }
}

