/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.mail.support;

import jakarta.mail.Folder;
import jakarta.mail.MessagingException;
import jakarta.mail.Service;
import jakarta.mail.URLName;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public abstract class MailTransportUtils {
    private static final Pattern TO_PATTERN = Pattern.compile("^([^\\?]+)");
    private static final Pattern SUBJECT_PATTERN = Pattern.compile("subject=([^\\&]+)");
    private static final Log logger = LogFactory.getLog(MailTransportUtils.class);

    private MailTransportUtils() {
    }

    public static InternetAddress getTo(URI uri) {
        Matcher matcher = TO_PATTERN.matcher(uri.getSchemeSpecificPart());
        if (matcher.find()) {
            for (int i2 = 1; i2 <= matcher.groupCount(); ++i2) {
                String group = matcher.group(i2);
                if (group == null) continue;
                try {
                    return new InternetAddress(group);
                }
                catch (AddressException addressException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static String getSubject(URI uri) {
        Matcher matcher = SUBJECT_PATTERN.matcher(uri.getSchemeSpecificPart());
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static void closeService(Service service) {
        if (service != null) {
            try {
                service.close();
            }
            catch (MessagingException ex) {
                logger.debug("Could not close JavaMail Service", ex);
            }
        }
    }

    public static void closeFolder(Folder folder) {
        MailTransportUtils.closeFolder(folder, false);
    }

    public static void closeFolder(Folder folder, boolean expunge) {
        if (folder != null && folder.isOpen()) {
            try {
                folder.close(expunge);
            }
            catch (MessagingException ex) {
                logger.debug("Could not close JavaMail Folder", ex);
            }
        }
    }

    public static String toPasswordProtectedString(URLName name) {
        String protocol = name.getProtocol();
        String username = name.getUsername();
        String password = name.getPassword();
        String host = name.getHost();
        int port = name.getPort();
        String file = name.getFile();
        String ref = name.getRef();
        StringBuilder tempURL = new StringBuilder();
        if (protocol != null) {
            tempURL.append(protocol).append(':');
        }
        if (StringUtils.hasLength(username) || StringUtils.hasLength(host)) {
            tempURL.append("//");
            if (StringUtils.hasLength(username)) {
                tempURL.append(username);
                if (StringUtils.hasLength(password)) {
                    tempURL.append(":*****");
                }
                tempURL.append("@");
            }
            if (StringUtils.hasLength(host)) {
                tempURL.append(host);
            }
            if (port != -1) {
                tempURL.append(':').append(Integer.toString(port));
            }
            if (StringUtils.hasLength(file)) {
                tempURL.append('/');
            }
        }
        if (StringUtils.hasLength(file)) {
            tempURL.append(file);
        }
        if (StringUtils.hasLength(ref)) {
            tempURL.append('#').append(ref);
        }
        return tempURL.toString();
    }

    public static URI toUri(InternetAddress to, String subject) throws URISyntaxException {
        if (StringUtils.hasLength(subject)) {
            return new URI("mailto", to.getAddress() + "?subject=" + subject, null);
        }
        return new URI("mailto", to.getAddress(), null);
    }
}

