/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.xmpp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.filter.ThreadFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.transport.AbstractSenderConnection;
import org.springframework.ws.transport.xmpp.MessageInputStream;
import org.springframework.ws.transport.xmpp.MessageOutputStream;
import org.springframework.ws.transport.xmpp.support.XmppTransportUtils;

public class XmppSenderConnection
extends AbstractSenderConnection {
    private final Message requestMessage;
    private final XMPPConnection connection;
    private Message responseMessage;
    private String messageEncoding;
    private long receiveTimeout;

    protected XmppSenderConnection(XMPPConnection connection, String to, String thread) {
        Assert.notNull((Object)connection, "'connection' must not be null");
        Assert.hasLength(to, "'to' must not be empty");
        Assert.hasLength(thread, "'thread' must not be empty");
        this.connection = connection;
        try {
            this.requestMessage = new Message(JidCreate.from((String)to), Message.Type.chat);
        }
        catch (XmppStringprepException e) {
            throw new RuntimeException(e);
        }
        this.requestMessage.setThread(thread);
    }

    public Message getRequestMessage() {
        return this.requestMessage;
    }

    public Message getResponseMessage() {
        return this.responseMessage;
    }

    void setMessageEncoding(String messageEncoding) {
        this.messageEncoding = messageEncoding;
    }

    void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    @Override
    public URI getUri() throws URISyntaxException {
        return XmppTransportUtils.toUri(this.requestMessage);
    }

    @Override
    public boolean hasError() {
        return XmppTransportUtils.hasError(this.responseMessage);
    }

    @Override
    public String getErrorMessage() {
        return XmppTransportUtils.getErrorMessage(this.responseMessage);
    }

    @Override
    public void addRequestHeader(String name, String value) {
        XmppTransportUtils.addHeader(this.requestMessage, name, value);
    }

    @Override
    protected OutputStream getRequestOutputStream() throws IOException {
        return new MessageOutputStream(this.requestMessage, this.messageEncoding);
    }

    @Override
    protected void onSendAfterWrite(WebServiceMessage message) throws IOException {
        this.requestMessage.setFrom((Jid)this.connection.getUser());
        try {
            this.connection.sendStanza((Stanza)this.requestMessage);
        }
        catch (InterruptedException | SmackException.NotConnectedException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void onReceiveBeforeRead() throws IOException {
        StanzaFilter packetFilter = this.createPacketFilter();
        StanzaCollector collector = this.connection.createStanzaCollector(packetFilter);
        try {
            Stanza packet;
            Stanza stanza = packet = this.receiveTimeout >= 0L ? collector.nextResult(this.receiveTimeout) : collector.nextResult();
            if (packet instanceof Message) {
                this.responseMessage = (Message)packet;
            } else if (packet != null) {
                throw new IllegalArgumentException("Wrong packet type: [" + packet.getClass() + "]. Only Messages can be handled.");
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private StanzaFilter createPacketFilter() {
        AndFilter andFilter = new AndFilter();
        andFilter.addFilter((StanzaFilter)new StanzaTypeFilter(Message.class));
        andFilter.addFilter((StanzaFilter)new ThreadFilter(this.requestMessage.getThread()));
        return andFilter;
    }

    @Override
    protected boolean hasResponse() throws IOException {
        return this.responseMessage != null;
    }

    @Override
    public Iterator<String> getResponseHeaderNames() {
        return XmppTransportUtils.getHeaderNames(this.responseMessage);
    }

    @Override
    public Iterator<String> getResponseHeaders(String name) throws IOException {
        return XmppTransportUtils.getHeaders(this.responseMessage, name);
    }

    @Override
    protected InputStream getResponseInputStream() throws IOException {
        return new MessageInputStream(this.responseMessage, this.messageEncoding);
    }
}

