/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.namespace;

import java.beans.PropertyEditorSupport;
import javax.xml.namespace.QName;
import org.springframework.util.StringUtils;
import org.springframework.xml.namespace.QNameUtils;

public class QNameEditor
extends PropertyEditorSupport {
    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(QNameUtils.parseQNameString(text));
    }

    @Override
    public String getAsText() {
        Object value = this.getValue();
        if (value instanceof QName) {
            QName qName = (QName)value;
            String prefix = qName.getPrefix();
            if (StringUtils.hasLength(qName.getNamespaceURI()) && StringUtils.hasLength(prefix)) {
                return "{" + qName.getNamespaceURI() + "}" + prefix + ":" + qName.getLocalPart();
            }
            if (StringUtils.hasLength(qName.getNamespaceURI())) {
                return "{" + qName.getNamespaceURI() + "}" + qName.getLocalPart();
            }
            return qName.getLocalPart();
        }
        return "";
    }
}

