/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.transform;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.StaxUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public abstract class TraxUtils {
    public static Document getDocument(DOMSource source) {
        Node node = source.getNode();
        if (node instanceof Document) {
            return (Document)node;
        }
        if (node != null) {
            return node.getOwnerDocument();
        }
        return null;
    }

    public static void doWithSource(Source source, SourceCallback callback) throws Exception {
        if (source instanceof DOMSource) {
            callback.domSource(((DOMSource)source).getNode());
            return;
        }
        if (StaxUtils.isStaxSource(source)) {
            XMLStreamReader streamReader = StaxUtils.getXMLStreamReader(source);
            if (streamReader != null) {
                callback.staxSource(streamReader);
                return;
            }
            XMLEventReader eventReader = StaxUtils.getXMLEventReader(source);
            if (eventReader != null) {
                callback.staxSource(eventReader);
                return;
            }
        } else {
            if (source instanceof SAXSource) {
                SAXSource saxSource = (SAXSource)source;
                callback.saxSource(saxSource.getXMLReader(), saxSource.getInputSource());
                return;
            }
            if (source instanceof StreamSource) {
                StreamSource streamSource = (StreamSource)source;
                if (streamSource.getInputStream() != null) {
                    callback.streamSource(streamSource.getInputStream());
                    return;
                }
                if (streamSource.getReader() != null) {
                    callback.streamSource(streamSource.getReader());
                    return;
                }
            }
        }
        if (!StringUtils.hasLength(source.getSystemId())) {
            throw new IllegalArgumentException("Unknown Source type: " + source.getClass());
        }
        String systemId = source.getSystemId();
        callback.source(systemId);
    }

    public static void doWithResult(Result result, ResultCallback callback) throws Exception {
        if (result instanceof DOMResult) {
            callback.domResult(((DOMResult)result).getNode());
            return;
        }
        if (StaxUtils.isStaxResult(result)) {
            XMLStreamWriter streamWriter = StaxUtils.getXMLStreamWriter(result);
            if (streamWriter != null) {
                callback.staxResult(streamWriter);
                return;
            }
            XMLEventWriter eventWriter = StaxUtils.getXMLEventWriter(result);
            if (eventWriter != null) {
                callback.staxResult(eventWriter);
                return;
            }
        } else {
            if (result instanceof SAXResult) {
                SAXResult saxSource = (SAXResult)result;
                callback.saxResult(saxSource.getHandler(), saxSource.getLexicalHandler());
                return;
            }
            if (result instanceof StreamResult) {
                StreamResult streamSource = (StreamResult)result;
                if (streamSource.getOutputStream() != null) {
                    callback.streamResult(streamSource.getOutputStream());
                    return;
                }
                if (streamSource.getWriter() != null) {
                    callback.streamResult(streamSource.getWriter());
                    return;
                }
            }
        }
        if (!StringUtils.hasLength(result.getSystemId())) {
            throw new IllegalArgumentException("Unknown Result type: " + result.getClass());
        }
        String systemId = result.getSystemId();
        callback.result(systemId);
    }

    public static interface SourceCallback {
        public void domSource(Node var1) throws Exception;

        public void saxSource(XMLReader var1, InputSource var2) throws Exception;

        public void staxSource(XMLEventReader var1) throws Exception;

        public void staxSource(XMLStreamReader var1) throws Exception;

        public void streamSource(InputStream var1) throws Exception;

        public void streamSource(Reader var1) throws Exception;

        public void source(String var1) throws Exception;
    }

    public static interface ResultCallback {
        public void domResult(Node var1) throws Exception;

        public void saxResult(ContentHandler var1, LexicalHandler var2) throws Exception;

        public void staxResult(XMLEventWriter var1) throws Exception;

        public void staxResult(XMLStreamWriter var1) throws Exception;

        public void streamResult(OutputStream var1) throws Exception;

        public void streamResult(Writer var1) throws Exception;

        public void result(String var1) throws Exception;
    }
}

