/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.xpath;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.xml.xpath.Jaxp13XPathExpressionFactory;
import org.springframework.xml.xpath.XPathExpression;
import org.springframework.xml.xpath.XPathParseException;

public abstract class XPathExpressionFactory {
    private static final Log logger = LogFactory.getLog(XPathExpressionFactory.class);

    public static XPathExpression createXPathExpression(String expression) throws IllegalStateException, XPathParseException {
        return XPathExpressionFactory.createXPathExpression(expression, Collections.emptyMap());
    }

    public static XPathExpression createXPathExpression(String expression, Map<String, String> namespaces) throws IllegalStateException, XPathParseException {
        Assert.hasLength(expression, "expression is empty");
        if (namespaces == null) {
            namespaces = Collections.emptyMap();
        }
        logger.trace("Creating [javax.xml.xpath.XPathExpression]");
        return Jaxp13XPathExpressionFactory.createXPathExpression(expression, namespaces);
    }
}

