/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.xpath;

import java.util.Map;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.xml.xpath.XPathExpression;
import org.springframework.xml.xpath.XPathExpressionFactory;
import org.springframework.xml.xpath.XPathParseException;

public class XPathExpressionFactoryBean
implements FactoryBean<XPathExpression>,
InitializingBean {
    private Map<String, String> namespaces;
    private String expressionString;
    private XPathExpression expression;

    public void setExpression(String expression) {
        this.expressionString = expression;
    }

    public void setNamespaces(Map<String, String> namespaces) {
        this.namespaces = namespaces;
    }

    @Override
    public void afterPropertiesSet() throws IllegalStateException, XPathParseException {
        Assert.notNull((Object)this.expressionString, "expression is required");
        this.expression = CollectionUtils.isEmpty(this.namespaces) ? XPathExpressionFactory.createXPathExpression(this.expressionString) : XPathExpressionFactory.createXPathExpression(this.expressionString, this.namespaces);
    }

    @Override
    public XPathExpression getObject() throws Exception {
        return this.expression;
    }

    @Override
    public Class<? extends XPathExpression> getObjectType() {
        return XPathExpression.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}

