/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.xml;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import org.apache.camel.component.properties.PropertiesLocation;
import org.apache.camel.model.IdentifiedType;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="spring,configuration")
@XmlRootElement(name="propertiesLocation")
public class CamelPropertyPlaceholderLocationDefinition
extends IdentifiedType {
    @XmlAttribute
    @Metadata(defaultValue="classpath")
    public String resolver;
    @XmlAttribute(required=true)
    public String path;
    @XmlAttribute
    @Metadata(defaultValue="false")
    public Boolean optional;

    public String getResolver() {
        return this.resolver;
    }

    public void setResolver(String resolver) {
        this.resolver = resolver;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Boolean getOptional() {
        return this.optional;
    }

    public void setOptional(Boolean optional) {
        this.optional = optional;
    }

    public String toString() {
        Object answer = this.path;
        if (ObjectHelper.isNotEmpty(this.resolver)) {
            answer = this.resolver + ":" + (String)answer;
        }
        if (ObjectHelper.isNotEmpty(this.optional)) {
            answer = (String)answer + ";optional=true";
        }
        return answer;
    }

    public PropertiesLocation toLocation() {
        return new PropertiesLocation(this.resolver != null ? this.resolver : "classpath", this.path, this.optional != null ? this.optional : false);
    }
}

