/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.xml.util.jsse;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlTransient;
import java.security.KeyStore;
import org.apache.camel.core.xml.util.jsse.AbstractJsseUtilFactoryBean;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.jsse.KeyStoreParameters;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class AbstractKeyStoreParametersFactoryBean
extends AbstractJsseUtilFactoryBean<KeyStoreParameters> {
    @XmlAttribute
    @Metadata(description="The keystore to load. The keystore is by default loaded from classpath. If you must load from file system, then use file: as prefix. file:nameOfFile (to refer to the file system) classpath:nameOfFile (to refer to the classpath; default) http:uri (to load the resource using HTTP) ref:nameOfBean (to lookup an existing KeyStore instance from the registry, for example for testing and development)")
    protected String resource;
    @XmlAttribute
    @Metadata(description="The password for reading/opening/verifying the key store")
    protected String password;
    @XmlAttribute
    @Metadata(label="advanced", description="The type of the key store to create and load. See https://docs.oracle.com/en/java/javase/17/docs/specs/security/standard-names.html")
    protected String type;
    @XmlAttribute
    @Metadata(label="advanced", description="The provider identifier for instantiating the key store")
    protected String provider;
    @XmlAttribute
    @Metadata(label="advanced", description="To lookup an existing KeyStore instance from the registry, for example for testing and development")
    protected String keyStore;
    @XmlTransient
    private KeyStoreParameters instance;

    public String getType() {
        return this.type;
    }

    public void setType(String value) {
        this.type = value;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String value) {
        this.password = value;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String value) {
        this.provider = value;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String value) {
        this.resource = value;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    @Override
    public KeyStoreParameters getObject() throws Exception {
        if (this.isSingleton()) {
            if (this.instance == null) {
                this.instance = this.createInstance();
            }
            return this.instance;
        }
        return this.createInstance();
    }

    protected KeyStoreParameters createInstance() {
        KeyStoreParameters newInstance = new KeyStoreParameters();
        newInstance.setCamelContext(this.getCamelContext());
        newInstance.setType(this.type);
        newInstance.setPassword(this.password);
        newInstance.setProvider(this.provider);
        newInstance.setResource(this.resource);
        if (this.keyStore != null) {
            KeyStore ks = CamelContextHelper.mandatoryLookup(this.getCamelContext(), this.keyStore, KeyStore.class);
            newInstance.setKeyStore(ks);
        }
        return newInstance;
    }

    @Override
    public Class<? extends KeyStoreParameters> getObjectType() {
        return KeyStoreParameters.class;
    }
}

