/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql;

import javax.sql.DataSource;
import org.apache.camel.CamelContext;
import org.apache.camel.component.sql.RowMapperFactory;
import org.apache.camel.component.sql.SqlComponent;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class SqlComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        SqlComponent target = (SqlComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled(SqlComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(SqlComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "datasource": 
            case "dataSource": {
                target.setDataSource(SqlComponentConfigurer.property(camelContext, DataSource.class, value));
                return true;
            }
            case "healthcheckconsumerenabled": 
            case "healthCheckConsumerEnabled": {
                target.setHealthCheckConsumerEnabled(SqlComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "healthcheckproducerenabled": 
            case "healthCheckProducerEnabled": {
                target.setHealthCheckProducerEnabled(SqlComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(SqlComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "rowmapperfactory": 
            case "rowMapperFactory": {
                target.setRowMapperFactory(SqlComponentConfigurer.property(camelContext, RowMapperFactory.class, value));
                return true;
            }
            case "servicelocationenabled": 
            case "serviceLocationEnabled": {
                target.setServiceLocationEnabled(SqlComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "useplaceholder": 
            case "usePlaceholder": {
                target.setUsePlaceholder(SqlComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public String[] getAutowiredNames() {
        return new String[]{"dataSource", "rowMapperFactory"};
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "datasource": 
            case "dataSource": {
                return DataSource.class;
            }
            case "healthcheckconsumerenabled": 
            case "healthCheckConsumerEnabled": {
                return Boolean.TYPE;
            }
            case "healthcheckproducerenabled": 
            case "healthCheckProducerEnabled": {
                return Boolean.TYPE;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "rowmapperfactory": 
            case "rowMapperFactory": {
                return RowMapperFactory.class;
            }
            case "servicelocationenabled": 
            case "serviceLocationEnabled": {
                return Boolean.TYPE;
            }
            case "useplaceholder": 
            case "usePlaceholder": {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        SqlComponent target = (SqlComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "datasource": 
            case "dataSource": {
                return target.getDataSource();
            }
            case "healthcheckconsumerenabled": 
            case "healthCheckConsumerEnabled": {
                return target.isHealthCheckConsumerEnabled();
            }
            case "healthcheckproducerenabled": 
            case "healthCheckProducerEnabled": {
                return target.isHealthCheckProducerEnabled();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "rowmapperfactory": 
            case "rowMapperFactory": {
                return target.getRowMapperFactory();
            }
            case "servicelocationenabled": 
            case "serviceLocationEnabled": {
                return target.isServiceLocationEnabled();
            }
            case "useplaceholder": 
            case "usePlaceholder": {
                return target.isUsePlaceholder();
            }
        }
        return null;
    }
}

