/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.idempotent.jdbc;

import javax.sql.DataSource;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.service.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@ManagedResource(description="JDBC IdempotentRepository")
public abstract class AbstractJdbcMessageIdRepository
extends ServiceSupport
implements IdempotentRepository {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Metadata(description="The name of the processor that are used for this repository. Use unique names to separate processors in the same database.", required=true)
    protected String processorName;
    @Metadata(description="The Spring JdbcTemplate to use for connecting to the database", required=true)
    protected JdbcTemplate jdbcTemplate;
    @Metadata(description="The Spring TransactionTemplate to use for connecting to the database", required=true)
    protected TransactionTemplate transactionTemplate;
    protected DataSource dataSource;

    public AbstractJdbcMessageIdRepository() {
    }

    public AbstractJdbcMessageIdRepository(JdbcTemplate jdbcTemplate, TransactionTemplate transactionTemplate) {
        this.jdbcTemplate = jdbcTemplate;
        this.transactionTemplate = transactionTemplate;
    }

    public AbstractJdbcMessageIdRepository(DataSource dataSource, TransactionTemplate transactionTemplate, String processorName) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.jdbcTemplate.afterPropertiesSet();
        this.processorName = processorName;
        this.transactionTemplate = transactionTemplate;
    }

    public AbstractJdbcMessageIdRepository(DataSource dataSource, String processorName) {
        this(dataSource, AbstractJdbcMessageIdRepository.createTransactionTemplate(dataSource), processorName);
    }

    protected abstract int queryForInt(String var1);

    protected abstract int insert(String var1);

    protected abstract int delete(String var1);

    protected abstract int delete();

    protected static TransactionTemplate createTransactionTemplate(DataSource dataSource) {
        TransactionTemplate transactionTemplate = new TransactionTemplate();
        transactionTemplate.setTransactionManager(new DataSourceTransactionManager(dataSource));
        transactionTemplate.setPropagationBehavior(0);
        return transactionTemplate;
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }

    @Override
    @ManagedOperation(description="Adds the key to the store")
    public boolean add(final String key) {
        Boolean rc = this.transactionTemplate.execute(new TransactionCallback<Boolean>(){

            @Override
            public Boolean doInTransaction(TransactionStatus status) {
                int count = AbstractJdbcMessageIdRepository.this.queryForInt(key);
                if (count == 0) {
                    AbstractJdbcMessageIdRepository.this.insert(key);
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        return rc;
    }

    @Override
    @ManagedOperation(description="Does the store contain the given key")
    public boolean contains(final String key) {
        Boolean rc = this.transactionTemplate.execute(new TransactionCallback<Boolean>(){

            @Override
            public Boolean doInTransaction(TransactionStatus status) {
                int count = AbstractJdbcMessageIdRepository.this.queryForInt(key);
                if (count == 0) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        return rc;
    }

    @Override
    @ManagedOperation(description="Remove the key from the store")
    public boolean remove(final String key) {
        Boolean rc = this.transactionTemplate.execute(new TransactionCallback<Boolean>(){

            @Override
            public Boolean doInTransaction(TransactionStatus status) {
                int updateCount = AbstractJdbcMessageIdRepository.this.delete(key);
                if (updateCount == 0) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        return rc;
    }

    @Override
    @ManagedOperation(description="Clear the store")
    public void clear() {
        this.transactionTemplate.execute(new TransactionCallback<Boolean>(){

            @Override
            public Boolean doInTransaction(TransactionStatus status) {
                AbstractJdbcMessageIdRepository.this.delete();
                return Boolean.TRUE;
            }
        });
    }

    @Override
    public boolean confirm(String key) {
        return true;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public String getProcessorName() {
        return this.processorName;
    }

    public void setProcessorName(String processorName) {
        this.processorName = processorName;
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

