/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql;

import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.component.sql.ResultSetIterator;
import org.apache.camel.component.sql.ResultSetIteratorCompletion;
import org.apache.camel.component.sql.SqlEndpoint;
import org.apache.camel.component.sql.SqlHelper;
import org.apache.camel.component.sql.SqlOutputType;
import org.apache.camel.component.sql.SqlPrepareStatementStrategy;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.ResourceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.support.JdbcUtils;

public class SqlProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(SqlProducer.class);
    private static final Object EMPTY_RESULT = new Object();
    private final String query;
    private String resolvedQuery;
    private final JdbcTemplate jdbcTemplate;
    private final boolean batch;
    private final boolean alwaysPopulateStatement;
    private final SqlPrepareStatementStrategy sqlPrepareStatementStrategy;
    private final boolean useMessageBodyForSql;
    private int parametersCount;

    public SqlProducer(SqlEndpoint endpoint, String query2, JdbcTemplate jdbcTemplate, SqlPrepareStatementStrategy sqlPrepareStatementStrategy, boolean batch, boolean alwaysPopulateStatement, boolean useMessageBodyForSql) {
        super(endpoint);
        this.jdbcTemplate = jdbcTemplate;
        this.sqlPrepareStatementStrategy = sqlPrepareStatementStrategy;
        this.query = query2;
        this.batch = batch;
        this.alwaysPopulateStatement = alwaysPopulateStatement;
        this.useMessageBodyForSql = useMessageBodyForSql;
    }

    @Override
    public SqlEndpoint getEndpoint() {
        return (SqlEndpoint)super.getEndpoint();
    }

    @Override
    protected void doInit() throws Exception {
        super.doInit();
        if (ResourceHelper.isClasspathUri(this.query)) {
            String placeholder = this.getEndpoint().isUsePlaceholder() ? this.getEndpoint().getPlaceholder() : null;
            this.resolvedQuery = SqlHelper.resolveQuery(this.getEndpoint().getCamelContext(), this.query, placeholder);
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (!ResourceHelper.isClasspathUri(this.query)) {
            String placeholder = this.getEndpoint().isUsePlaceholder() ? this.getEndpoint().getPlaceholder() : null;
            this.resolvedQuery = SqlHelper.resolveQuery(this.getEndpoint().getCamelContext(), this.query, placeholder);
        }
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String sql;
        if (this.useMessageBodyForSql) {
            sql = exchange.getIn().getBody(String.class);
        } else {
            String queryHeader = exchange.getIn().getHeader("CamelSqlQuery", String.class);
            if (queryHeader != null) {
                String placeholder = this.getEndpoint().isUsePlaceholder() ? this.getEndpoint().getPlaceholder() : null;
                sql = SqlHelper.resolvePlaceholders(queryHeader, placeholder);
            } else {
                sql = this.resolvedQuery;
            }
        }
        String preparedQuery = this.sqlPrepareStatementStrategy.prepareQuery(sql, this.getEndpoint().isAllowNamedParameters(), exchange);
        Boolean shouldRetrieveGeneratedKeys = exchange.getIn().getHeader("CamelSqlRetrieveGeneratedKeys", false, Boolean.class);
        PreparedStatementCreator statementCreator = con -> {
            if (!shouldRetrieveGeneratedKeys.booleanValue()) {
                return con.prepareStatement(preparedQuery);
            }
            Object expectedGeneratedColumns = exchange.getIn().getHeader("CamelSqlGeneratedColumns");
            if (expectedGeneratedColumns == null) {
                return con.prepareStatement(preparedQuery, 1);
            }
            if (expectedGeneratedColumns instanceof String[]) {
                return con.prepareStatement(preparedQuery, (String[])expectedGeneratedColumns);
            }
            if (expectedGeneratedColumns instanceof int[]) {
                return con.prepareStatement(preparedQuery, (int[])expectedGeneratedColumns);
            }
            throw new IllegalArgumentException("Header specifying expected returning columns isn't an instance of String[] or int[] but " + String.valueOf(expectedGeneratedColumns.getClass()));
        };
        Object data = this.getEndpoint().getOutputType() == SqlOutputType.StreamList ? this.processStreamList(exchange, statementCreator, sql, preparedQuery) : this.processInternal(exchange, statementCreator, sql, preparedQuery, shouldRetrieveGeneratedKeys);
        if (this.getEndpoint().getOutputHeader() != null) {
            exchange.getIn().setHeader(this.getEndpoint().getOutputHeader(), data == EMPTY_RESULT ? null : data);
        } else if (data != null && !this.getEndpoint().isNoop()) {
            exchange.getIn().setBody(data == EMPTY_RESULT ? null : data);
        }
    }

    private Object processInternal(final Exchange exchange, PreparedStatementCreator statementCreator, final String sql, final String preparedQuery, final Boolean shouldRetrieveGeneratedKeys) {
        LOG.trace("jdbcTemplate.execute: {}", (Object)preparedQuery);
        return this.jdbcTemplate.execute(statementCreator, new PreparedStatementCallback<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object doInPreparedStatement(PreparedStatement ps) throws SQLException {
                List<?> list;
                Object data = null;
                ResultSet rs = null;
                try {
                    SqlProducer.this.populateStatement(ps, exchange, sql, preparedQuery);
                    boolean isResultSet = false;
                    if (SqlProducer.this.batch) {
                        int[] updateCounts = ps.executeBatch();
                        int total = 0;
                        for (int count : updateCounts) {
                            total += count;
                        }
                        exchange.getIn().setHeader("CamelSqlUpdateCount", total);
                    } else {
                        isResultSet = ps.execute();
                        if (isResultSet) {
                            rs = ps.getResultSet();
                            SqlOutputType outputType = SqlProducer.this.getEndpoint().getOutputType();
                            LOG.trace("Got result list from query: {}, outputType={}", (Object)rs, (Object)outputType);
                            int rowCount = 0;
                            if (outputType == SqlOutputType.SelectList) {
                                data = SqlProducer.this.getEndpoint().queryForList(rs, true);
                                rowCount = data.size();
                            } else if (outputType == SqlOutputType.SelectOne) {
                                data = SqlProducer.this.getEndpoint().queryForObject(rs);
                                if (data != null) {
                                    rowCount = 1;
                                } else {
                                    data = EMPTY_RESULT;
                                }
                            } else {
                                throw new IllegalArgumentException("Invalid outputType=" + String.valueOf((Object)outputType));
                            }
                            exchange.getIn().setHeader("CamelSqlRowCount", rowCount);
                        } else {
                            exchange.getIn().setHeader("CamelSqlUpdateCount", ps.getUpdateCount());
                        }
                    }
                    if (shouldRetrieveGeneratedKeys.booleanValue()) {
                        if (isResultSet) {
                            exchange.getIn().setHeader("CamelSqlGeneratedKeyRows", Collections.emptyList());
                            exchange.getIn().setHeader("CamelSqlGeneratedKeysRowCount", 0);
                        } else {
                            List<?> generatedKeys = SqlProducer.this.getEndpoint().queryForList(ps.getGeneratedKeys(), false);
                            exchange.getIn().setHeader("CamelSqlGeneratedKeyRows", generatedKeys);
                            exchange.getIn().setHeader("CamelSqlGeneratedKeysRowCount", generatedKeys.size());
                        }
                    }
                    list = data;
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeResultSet(rs);
                    throw throwable;
                }
                JdbcUtils.closeResultSet(rs);
                return list;
            }
        });
    }

    protected Object processStreamList(Exchange exchange, PreparedStatementCreator statementCreator, String sql, String preparedQuery) throws Exception {
        LOG.trace("processStreamList: {}", (Object)preparedQuery);
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = this.jdbcTemplate.getDataSource().getConnection();
            ps = statementCreator.createPreparedStatement(con);
            ResultSetIterator iterator = null;
            this.populateStatement(ps, exchange, sql, preparedQuery);
            boolean isResultSet = ps.execute();
            if (isResultSet) {
                rs = ps.getResultSet();
                iterator = this.getEndpoint().queryForStreamList(con, ps, rs);
                exchange.getExchangeExtension().addOnCompletion(new ResultSetIteratorCompletion(iterator));
            }
            return iterator;
        }
        catch (Exception e) {
            JdbcUtils.closeConnection(con);
            JdbcUtils.closeStatement(ps);
            JdbcUtils.closeResultSet(rs);
            throw e;
        }
    }

    private void populateStatement(PreparedStatement ps, Exchange exchange, String sql, String preparedQuery) throws SQLException {
        int expected;
        if (this.parametersCount > 0) {
            expected = this.parametersCount;
        } else {
            ParameterMetaData meta = ps.getParameterMetaData();
            int n = expected = meta != null ? meta.getParameterCount() : 0;
        }
        if (this.alwaysPopulateStatement || expected > 0) {
            if (this.batch) {
                Iterator iterator = this.useMessageBodyForSql ? exchange.getIn().getHeader("CamelSqlParameters", Iterator.class) : exchange.getIn().getBody(Iterator.class);
                while (iterator != null && iterator.hasNext()) {
                    Object value = iterator.next();
                    Iterator<?> i = this.sqlPrepareStatementStrategy.createPopulateIterator(sql, preparedQuery, expected, exchange, value);
                    this.sqlPrepareStatementStrategy.populateStatement(ps, i, expected);
                    ps.addBatch();
                }
            } else {
                Object value = this.useMessageBodyForSql ? exchange.getIn().getHeader("CamelSqlParameters") : exchange.getIn().getBody();
                Iterator<?> i = this.sqlPrepareStatementStrategy.createPopulateIterator(sql, preparedQuery, expected, exchange, value);
                this.sqlPrepareStatementStrategy.populateStatement(ps, i, expected);
            }
        }
    }

    public void setParametersCount(int parametersCount) {
        this.parametersCount = parametersCount;
    }
}

