/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql;

import java.util.HashMap;
import javax.sql.DataSource;
import org.apache.camel.spi.BeanIntrospection;
import org.springframework.jdbc.datasource.AbstractDriverBasedDataSource;

public class SqlServiceLocationHelper {
    public static String getJDBCURLFromDataSource(BeanIntrospection bi, DataSource ds) {
        if (ds == null) {
            return null;
        }
        if (ds instanceof AbstractDriverBasedDataSource) {
            AbstractDriverBasedDataSource ads = (AbstractDriverBasedDataSource)ds;
            return ads.getUrl();
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        bi.getProperties(ds, props, null, false);
        Object url = props.get("url");
        if (url == null) {
            url = props.get("jdbcUrl");
        }
        if (url != null) {
            return url.toString();
        }
        DataSource ncf = (DataSource)props.get("dataSource");
        if (ncf != null) {
            return SqlServiceLocationHelper.getJDBCURLFromDataSource(bi, ncf);
        }
        return null;
    }

    public static String getUsernameFromConnectionFactory(BeanIntrospection bi, DataSource ds) {
        if (ds == null) {
            return null;
        }
        if (ds instanceof AbstractDriverBasedDataSource) {
            AbstractDriverBasedDataSource ads = (AbstractDriverBasedDataSource)ds;
            return ads.getUsername();
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        bi.getProperties(ds, props, null, false);
        Object user = props.get("user");
        if (user == null) {
            user = props.get("username");
        }
        if (user == null) {
            user = props.get("userName");
        }
        if (user != null) {
            return user.toString();
        }
        DataSource ncf = (DataSource)props.get("dataSource");
        if (ncf != null) {
            return SqlServiceLocationHelper.getUsernameFromConnectionFactory(bi, ncf);
        }
        return null;
    }
}

