/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource.embedded;

import javax.sql.DataSource;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseFactory;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.DatabasePopulatorUtils;
import org.springframework.lang.Nullable;

public class EmbeddedDatabaseFactoryBean
extends EmbeddedDatabaseFactory
implements FactoryBean<DataSource>,
InitializingBean,
DisposableBean {
    @Nullable
    private DatabasePopulator databaseCleaner;

    public void setDatabaseCleaner(DatabasePopulator databaseCleaner) {
        this.databaseCleaner = databaseCleaner;
    }

    @Override
    public void afterPropertiesSet() {
        this.initDatabase();
    }

    @Override
    @Nullable
    public DataSource getObject() {
        return this.getDataSource();
    }

    @Override
    public Class<? extends DataSource> getObjectType() {
        return DataSource.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public void destroy() {
        DatabasePopulator cleaner = this.databaseCleaner;
        if (cleaner != null && this.getDataSource() != null) {
            DatabasePopulatorUtils.execute(cleaner, this.getDataSource());
        }
        this.shutdownDatabase();
    }
}

