/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ssh;

import java.util.Map;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.ssh.ResourceBasedSSHKeyVerifier;
import org.apache.camel.component.ssh.SshConfiguration;
import org.apache.camel.component.ssh.SshEndpoint;
import org.apache.camel.component.ssh.SshHelper;
import org.apache.camel.component.ssh.SshResult;
import org.apache.camel.component.ssh.SshUtils;
import org.apache.camel.support.DefaultProducer;
import org.apache.sshd.client.SshClient;

public class SshProducer
extends DefaultProducer {
    private SshEndpoint endpoint;
    private SshClient client;

    public SshProducer(SshEndpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
    }

    @Override
    protected void doStart() throws Exception {
        this.client = this.endpoint.getConfiguration() == null || this.endpoint.getConfiguration().getClientBuilder() == null ? SshClient.setUpDefaultClient() : this.endpoint.getConfiguration().getClientBuilder().build(true);
        SshConfiguration configuration = this.endpoint.getConfiguration();
        SshUtils.configureAlgorithms(configuration, this.client);
        this.client.start();
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this.client != null) {
            this.client.stop();
            this.client = null;
        }
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        String command = in.getMandatoryBody(String.class);
        Map<String, Object> headers = exchange.getIn().getHeaders();
        try {
            String knownHostResource = this.endpoint.getKnownHostsResource();
            if (knownHostResource != null) {
                this.client.setServerKeyVerifier(new ResourceBasedSSHKeyVerifier(exchange.getContext(), knownHostResource, this.endpoint.isFailOnUnknownHost()));
            }
            SshResult result = SshHelper.sendExecCommand(headers, command, this.endpoint, this.client);
            exchange.getOut().setBody(result.getStdout());
            exchange.getOut().setHeader("CamelSshExitValue", result.getExitValue());
            exchange.getOut().setHeader("CamelSshStderr", result.getStderr());
        }
        catch (Exception e) {
            throw new CamelExchangeException("Cannot execute command: " + command, exchange, e);
        }
        exchange.getOut().getHeaders().putAll(in.getHeaders());
    }
}

