/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stax;

import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Map;
import org.apache.camel.support.LRUCacheFactory;

public final class StAXUtil {
    private static final Map<Class<?>, String> TAG_NAMES = LRUCacheFactory.newLRUSoftCache(1000);

    private StAXUtil() {
    }

    public static String getTagName(Class<?> handled) {
        if (TAG_NAMES.containsKey(handled)) {
            return TAG_NAMES.get(handled);
        }
        XmlType xmlType = handled.getAnnotation(XmlType.class);
        if (xmlType != null && xmlType.name() != null && !xmlType.name().isBlank()) {
            TAG_NAMES.put(handled, xmlType.name());
            return xmlType.name();
        }
        XmlRootElement xmlRoot = handled.getAnnotation(XmlRootElement.class);
        if (xmlRoot != null && xmlRoot.name() != null && !xmlRoot.name().isBlank()) {
            TAG_NAMES.put(handled, xmlRoot.name());
            return xmlRoot.name();
        }
        throw new IllegalArgumentException("XML name not found for " + handled.getName());
    }
}

