/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.stomp.jms;

import java.net.URI;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.net.ssl.SSLContext;
import org.fusesource.stomp.jms.StompChannel;
import org.fusesource.stomp.jms.StompJmsConnectionMetaData;
import org.fusesource.stomp.jms.StompJmsExceptionSupport;
import org.fusesource.stomp.jms.StompJmsPrefetch;
import org.fusesource.stomp.jms.StompJmsQueueSession;
import org.fusesource.stomp.jms.StompJmsSession;
import org.fusesource.stomp.jms.StompJmsTempQueue;
import org.fusesource.stomp.jms.StompJmsTempTopic;
import org.fusesource.stomp.jms.StompJmsTopicSession;
import org.fusesource.stomp.jms.StompServerAdaptor;

public class StompJmsConnection
implements Connection,
TopicConnection,
QueueConnection {
    private String clientId;
    private int clientNumber = 0;
    private boolean clientIdSet;
    private ExceptionListener exceptionListener;
    private List<StompJmsSession> sessions = new CopyOnWriteArrayList<StompJmsSession>();
    private AtomicBoolean connected = new AtomicBoolean();
    private AtomicBoolean closed = new AtomicBoolean();
    private AtomicBoolean started = new AtomicBoolean();
    String queuePrefix = "/queue/";
    String topicPrefix = "/topic/";
    String tempQueuePrefix = "/temp-queue/";
    String tempTopicPrefix = "/temp-topic/";
    boolean forceAsyncSend;
    boolean omitHost;
    final URI brokerURI;
    final URI localURI;
    final String userName;
    final String password;
    final SSLContext sslContext;
    StompChannel channel;
    long disconnectTimeout = 10000L;
    StompJmsPrefetch prefetch = new StompJmsPrefetch();

    protected StompJmsConnection(URI brokerURI, URI localURI, String userName, String password, SSLContext sslContext) throws JMSException {
        this.brokerURI = brokerURI;
        this.localURI = localURI;
        this.userName = userName;
        this.password = password;
        this.sslContext = sslContext;
    }

    public synchronized void close() throws JMSException {
        if (this.closed.compareAndSet(false, true)) {
            try {
                for (Session session : this.sessions) {
                    session.close();
                }
                this.sessions.clear();
                if (this.channel != null) {
                    this.channel.close();
                    this.channel = null;
                }
            }
            catch (Exception e) {
                throw StompJmsExceptionSupport.create(e);
            }
        }
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosed();
        this.connect();
        throw new JMSException("Not supported");
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosed();
        this.connect();
        throw new JMSException("Not supported");
    }

    public synchronized Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosed();
        this.connect();
        int ackMode = this.getSessionAcknowledgeMode(transacted, acknowledgeMode);
        StompJmsSession result = new StompJmsSession(this, ackMode, this.forceAsyncSend);
        this.addSession(result);
        if (this.started.get()) {
            result.start();
        }
        return result;
    }

    public String getClientID() {
        return this.clientId;
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public ConnectionMetaData getMetaData() {
        return StompJmsConnectionMetaData.INSTANCE;
    }

    public synchronized void setClientID(String clientID) throws JMSException {
        if (this.clientIdSet) {
            throw new IllegalStateException("The clientID has already been set");
        }
        if (clientID == null) {
            throw new IllegalStateException("Cannot have a null clientID");
        }
        if (this.connected.get()) {
            throw new IllegalStateException("Cannot set the client id once connected.");
        }
        this.clientId = clientID;
        this.clientIdSet = true;
    }

    public void setExceptionListener(ExceptionListener listener) {
        this.exceptionListener = listener;
    }

    public void start() throws JMSException {
        this.checkClosed();
        this.connect();
        if (this.started.compareAndSet(false, true)) {
            try {
                for (StompJmsSession s : this.sessions) {
                    s.start();
                }
            }
            catch (Exception e) {
                throw StompJmsExceptionSupport.create(e);
            }
        }
    }

    public void stop() throws JMSException {
        this.checkClosed();
        this.connect();
        if (this.started.compareAndSet(true, false)) {
            try {
                for (StompJmsSession s : this.sessions) {
                    s.stop();
                }
            }
            catch (Exception e) {
                throw StompJmsExceptionSupport.create(e);
            }
        }
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosed();
        this.connect();
        return null;
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosed();
        this.connect();
        int ackMode = this.getSessionAcknowledgeMode(transacted, acknowledgeMode);
        StompJmsTopicSession result = new StompJmsTopicSession(this, ackMode, this.forceAsyncSend);
        this.addSession(result);
        if (this.started.get()) {
            result.start();
        }
        return result;
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosed();
        this.connect();
        return null;
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosed();
        this.connect();
        int ackMode = this.getSessionAcknowledgeMode(transacted, acknowledgeMode);
        StompJmsQueueSession result = new StompJmsQueueSession(this, ackMode, this.forceAsyncSend);
        this.addSession(result);
        if (this.started.get()) {
            result.start();
        }
        return result;
    }

    public void onException(Exception ex) {
        this.onException(StompJmsExceptionSupport.create(ex));
    }

    public void onException(JMSException ex) {
        ExceptionListener l = this.exceptionListener;
        if (l != null) {
            l.onException(StompJmsExceptionSupport.create((Exception)((Object)ex)));
        }
    }

    protected int getSessionAcknowledgeMode(boolean transacted, int acknowledgeMode) throws JMSException {
        int result = acknowledgeMode;
        if (!transacted && acknowledgeMode == 0) {
            throw new JMSException("acknowledgeMode SESSION_TRANSACTED cannot be used for an non-transacted Session");
        }
        if (transacted) {
            result = 0;
        }
        return result;
    }

    protected synchronized StompChannel createChannel() throws JMSException {
        StompChannel rc = new StompChannel();
        rc.setBrokerURI(this.brokerURI);
        rc.setLocalURI(this.localURI);
        rc.setUserName(this.userName);
        rc.setPassword(this.password);
        rc.setClientId(this.clientId);
        rc.setOmitHost(this.omitHost);
        rc.setSslContext(this.sslContext);
        rc.setDisconnectTimeout(this.disconnectTimeout);
        rc.setExceptionListener(this.exceptionListener);
        rc.setChannelId(this.clientId + "-" + this.clientNumber++);
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StompChannel getChannel() throws JMSException {
        StompChannel rc;
        StompJmsConnection stompJmsConnection = this;
        synchronized (stompJmsConnection) {
            if (this.channel == null) {
                this.channel = this.createChannel();
            }
            rc = this.channel;
        }
        rc.connect();
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StompChannel createChannel(StompJmsSession s) throws JMSException {
        StompChannel rc;
        this.checkClosed();
        StompJmsConnection stompJmsConnection = this;
        synchronized (stompJmsConnection) {
            if (this.channel != null) {
                rc = this.channel;
                this.channel = null;
            } else {
                rc = this.createChannel();
            }
        }
        rc.connect();
        rc.setListener(s);
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSession(StompJmsSession s, StompChannel channel) throws JMSException {
        StompJmsConnection stompJmsConnection = this;
        synchronized (stompJmsConnection) {
            this.sessions.remove(s);
            if (channel != null && this.channel == null) {
                this.channel = channel;
                channel = null;
            }
        }
        if (channel != null) {
            channel.setListener(null);
            channel.close();
        }
    }

    protected void addSession(StompJmsSession s) {
        this.sessions.add(s);
    }

    protected void checkClosed() throws IllegalStateException {
        if (this.closed.get()) {
            throw new IllegalStateException("The MessageProducer is closed");
        }
    }

    private void connect() throws JMSException {
        if (this.connected.compareAndSet(false, true)) {
            this.getChannel();
        }
    }

    public boolean isForceAsyncSend() {
        return this.forceAsyncSend;
    }

    public void setForceAsyncSend(boolean forceAsyncSend) {
        this.forceAsyncSend = forceAsyncSend;
    }

    public String getTopicPrefix() {
        return this.topicPrefix;
    }

    public void setTopicPrefix(String topicPrefix) {
        this.topicPrefix = topicPrefix;
    }

    public String getTempTopicPrefix() {
        return this.tempTopicPrefix;
    }

    public void setTempTopicPrefix(String tempTopicPrefix) {
        this.tempTopicPrefix = tempTopicPrefix;
    }

    public String getTempQueuePrefix() {
        return this.tempQueuePrefix;
    }

    public void setTempQueuePrefix(String tempQueuePrefix) {
        this.tempQueuePrefix = tempQueuePrefix;
    }

    public String getQueuePrefix() {
        return this.queuePrefix;
    }

    public void setQueuePrefix(String queuePrefix) {
        this.queuePrefix = queuePrefix;
    }

    public boolean isOmitHost() {
        return this.omitHost;
    }

    public void setOmitHost(boolean omitHost) {
        this.omitHost = omitHost;
    }

    StompJmsTempQueue isTempQueue(String value) throws JMSException {
        this.connect();
        return this.serverAdaptor().isTempQueue(this, value);
    }

    StompServerAdaptor serverAdaptor() throws JMSException {
        return this.getChannel().getServerAdaptor();
    }

    StompJmsTempTopic isTempTopic(String value) throws JMSException {
        this.connect();
        return this.serverAdaptor().isTempTopic(this, value);
    }

    public StompJmsPrefetch getPrefetch() {
        return this.prefetch;
    }

    public void setPrefetch(StompJmsPrefetch prefetch) {
        this.prefetch = prefetch;
    }

    public long getDisconnectTimeout() {
        return this.disconnectTimeout;
    }

    public void setDisconnectTimeout(long disconnectTimeout) {
        this.disconnectTimeout = disconnectTimeout;
    }
}

