/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.stomp.jms;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.stomp.codec.StompFrame;
import org.fusesource.stomp.jms.StompJmsConnection;
import org.fusesource.stomp.jms.StompJmsQueue;
import org.fusesource.stomp.jms.StompJmsTopic;
import org.fusesource.stomp.jms.jndi.JNDIStorable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StompJmsDestination
extends JNDIStorable
implements Externalizable,
Destination,
Comparable<StompJmsDestination> {
    protected transient String prefix;
    protected transient String name;
    protected transient boolean topic;
    protected transient boolean temporary;
    protected transient int hashValue;
    protected transient String toString;
    protected transient AsciiBuffer buffer;
    protected transient Map<String, String> subscribeHeaders;

    public StompJmsDestination() {
    }

    public StompJmsDestination(String name) {
        this("", name);
    }

    public StompJmsDestination(String prefix, String name) {
        this.prefix = prefix;
        this.setName(name);
    }

    public StompJmsDestination copy() {
        StompJmsDestination copy = new StompJmsDestination();
        copy.setProperties(this.getProperties());
        return copy;
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = this.getPrefix() + this.getName();
        }
        return this.toString;
    }

    public AsciiBuffer toBuffer() {
        if (this.buffer == null) {
            this.buffer = StompFrame.encodeHeader(this.toString());
        }
        return this.buffer;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
        this.toString = null;
        this.buffer = null;
    }

    public boolean isTopic() {
        return this.topic;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public boolean isQueue() {
        return !this.topic;
    }

    @Override
    protected void buildFromProperties(Map<String, String> props) {
        this.setPrefix(this.getProperty(props, "prefix", ""));
        this.setName(this.getProperty(props, "name", ""));
        Boolean bool = Boolean.valueOf(this.getProperty(props, "topic", Boolean.TRUE.toString()));
        this.topic = bool;
        bool = Boolean.valueOf(this.getProperty(props, "temporary", Boolean.FALSE.toString()));
        this.temporary = bool;
    }

    @Override
    protected void populateProperties(Map<String, String> props) {
        props.put("prefix", this.getPrefix());
        props.put("name", this.getName());
        props.put("topic", Boolean.toString(this.isTopic()));
        props.put("temporary", Boolean.toString(this.isTemporary()));
    }

    @Override
    public int compareTo(StompJmsDestination other) {
        if (other != null) {
            if (this.isTemporary() == other.isTemporary()) {
                return this.getName().compareTo(other.getName());
            }
            return -1;
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StompJmsDestination d = (StompJmsDestination)o;
        return this.getName().equals(d.getName());
    }

    public int hashCode() {
        if (this.hashValue == 0) {
            this.hashValue = this.getName().hashCode();
        }
        return this.hashValue;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.getPrefix());
        out.writeUTF(this.getName());
        out.writeBoolean(this.isTopic());
        out.writeBoolean(this.isTemporary());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setPrefix(in.readUTF());
        this.setName(in.readUTF());
        this.topic = in.readBoolean();
        this.temporary = in.readBoolean();
    }

    public static StompJmsDestination createDestination(StompJmsConnection connection, String name) throws JMSException {
        StompJmsDestination x = connection.isTempQueue(name);
        if (x != null) {
            return x;
        }
        x = connection.isTempTopic(name);
        if (x != null) {
            return x;
        }
        if (name.startsWith(connection.topicPrefix)) {
            return new StompJmsTopic(connection, name.substring(connection.topicPrefix.length()));
        }
        if (name.startsWith(connection.queuePrefix)) {
            return new StompJmsQueue(connection, name.substring(connection.queuePrefix.length()));
        }
        return new StompJmsDestination("", name);
    }

    public Map<String, String> getSubscribeHeaders() {
        return this.subscribeHeaders;
    }

    public void setSubscribeHeaders(Map<String, String> subscribeHeaders) {
        this.subscribeHeaders = subscribeHeaders;
    }

    @Deprecated
    public String getPhysicalName() {
        return this.getName();
    }
}

