/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.stomp.jms.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.BufferInputStream;
import org.fusesource.hawtbuf.BufferOutputStream;
import org.fusesource.hawtbuf.DataByteArrayInputStream;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;
import org.fusesource.stomp.jms.util.ClassLoadingAwareObjectInputStream;

public class IOUtils {
    public static InputStream getByteBufferInputStream(final ByteBuffer buf) {
        return new InputStream(){

            public int read() throws IOException {
                if (!buf.hasRemaining()) {
                    return -1;
                }
                return buf.get();
            }

            public int read(byte[] bytes, int off, int len) throws IOException {
                int toWrite = Math.min(len, buf.remaining());
                buf.get(bytes, off, toWrite);
                return len;
            }
        };
    }

    public static OutputStream getByteBufferOutputStream(final ByteBuffer buf) {
        return new OutputStream(){

            public void write(int b) throws IOException {
                buf.put((byte)b);
            }

            public void write(byte[] bytes, int off, int len) throws IOException {
                buf.put(bytes, off, len);
            }
        };
    }

    public static Buffer getBuffer(Object object) throws IOException {
        if (object != null) {
            BufferOutputStream bufferOut = new BufferOutputStream(512);
            DataOutputStream dataOut = new DataOutputStream(bufferOut);
            ObjectOutputStream objOut = new ObjectOutputStream(dataOut);
            objOut.writeObject(object);
            objOut.flush();
            objOut.reset();
            objOut.close();
            return bufferOut.toBuffer();
        }
        return null;
    }

    public static void writeObject(DataByteArrayOutputStream out, Object object) throws IOException {
        if (object != null) {
            ByteArrayOutputStream bufferOut = new ByteArrayOutputStream(512);
            ObjectOutputStream objOut = new ObjectOutputStream(bufferOut);
            objOut.writeObject(object);
            objOut.flush();
            objOut.close();
            byte[] data = bufferOut.toByteArray();
            out.writeInt(data.length);
            out.write(data);
        } else {
            out.writeInt(0);
        }
    }

    public static Object readObject(DataByteArrayInputStream in) throws IOException {
        Object result = null;
        int len = in.readInt();
        if (len > 0) {
            byte[] rawData = new byte[len];
            in.readFully(rawData);
            ByteArrayInputStream is = new ByteArrayInputStream(rawData);
            DataInputStream dataIn = new DataInputStream(is);
            ClassLoadingAwareObjectInputStream objIn = new ClassLoadingAwareObjectInputStream(dataIn);
            try {
                result = objIn.readObject();
            }
            catch (ClassNotFoundException e) {
                IOException ex = new IOException("Class not Found " + e.getMessage());
                ex.initCause(e);
                throw ex;
            }
        }
        return result;
    }

    public static Object getObject(Buffer buffer) throws IOException {
        if (buffer != null) {
            ByteArrayInputStream is = new ByteArrayInputStream(buffer.data, buffer.offset, buffer.length);
            DataInputStream dataIn = new DataInputStream(is);
            ClassLoadingAwareObjectInputStream objIn = new ClassLoadingAwareObjectInputStream(dataIn);
            try {
                return objIn.readObject();
            }
            catch (ClassNotFoundException e) {
                IOException ex = new IOException("Class not Found " + e.getMessage());
                ex.initCause(e);
                throw ex;
            }
        }
        return null;
    }

    public static Buffer compress(Buffer buffer) throws IOException {
        Buffer result = buffer;
        if (buffer != null) {
            BufferOutputStream bytesOut = new BufferOutputStream(buffer.length);
            GZIPOutputStream gzipOut = new GZIPOutputStream((OutputStream)bytesOut, buffer.length);
            gzipOut.write(buffer.toByteArray());
            gzipOut.close();
            bytesOut.close();
            result = bytesOut.toBuffer();
        }
        return result;
    }

    public static Buffer inflate(Buffer buffer) throws IOException {
        Buffer result = buffer;
        if (IOUtils.isCompressed(buffer)) {
            BufferInputStream bytesIn = new BufferInputStream(buffer);
            GZIPInputStream gzipIn = new GZIPInputStream(bytesIn);
            BufferOutputStream bytesOut = new BufferOutputStream(buffer.length);
            byte[] data = new byte[4096];
            int bytesRead = 0;
            while ((bytesRead = gzipIn.read(data, 0, data.length)) > 0) {
                bytesOut.write(data, 0, bytesRead);
            }
            gzipIn.close();
            bytesIn.close();
            result = bytesOut.toBuffer();
            bytesOut.close();
        }
        return result;
    }

    static boolean isCompressed(Buffer data) {
        boolean result = false;
        if (data != null && data.length > 2) {
            int ch2;
            int ch1 = data.get(0) & 0xFF;
            int magic = ch1 | (ch2 = data.get(1) & 0xFF) << 8;
            result = magic == 35615;
        }
        return result;
    }
}

