/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.stomp.jms.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import org.fusesource.stomp.jms.StompJmsDestination;
import org.fusesource.stomp.jms.StompJmsExceptionSupport;
import org.fusesource.stomp.jms.message.StompJmsMessage;

public class PropertyExpression {
    private static final Map<String, SubExpression> JMS_PROPERTY_EXPRESSIONS = new HashMap<String, SubExpression>();
    private final String name;
    private final SubExpression jmsPropertyExpression;

    public PropertyExpression(String name) {
        this.name = name;
        this.jmsPropertyExpression = JMS_PROPERTY_EXPRESSIONS.get(name);
    }

    public Object evaluate(StompJmsMessage message) throws JMSException {
        if (this.jmsPropertyExpression != null) {
            return this.jmsPropertyExpression.evaluate(message);
        }
        try {
            return message.getProperties().get(this.name);
        }
        catch (IOException ioe) {
            throw StompJmsExceptionSupport.create(ioe);
        }
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        return this.name.equals(((PropertyExpression)o).name);
    }

    static {
        JMS_PROPERTY_EXPRESSIONS.put("JMSDestination", new SubExpression(){

            public Object evaluate(StompJmsMessage message) {
                try {
                    StompJmsDestination dest = message.getStompJmsDestination();
                    if (dest == null) {
                        return null;
                    }
                    return dest.toString();
                }
                catch (JMSException e) {
                    return null;
                }
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSReplyTo", new SubExpression(){

            public Object evaluate(StompJmsMessage message) {
                try {
                    StompJmsDestination dest = message.getStompJmsReplyTo();
                    if (dest == null) {
                        return null;
                    }
                    return dest.toString();
                }
                catch (JMSException e) {
                    return null;
                }
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSType", new SubExpression(){

            public Object evaluate(StompJmsMessage message) {
                return message.getJMSType();
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSDeliveryMode", new SubExpression(){

            public Object evaluate(StompJmsMessage message) {
                return message.isPersistent() ? 2 : 1;
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSPriority", new SubExpression(){

            public Object evaluate(StompJmsMessage message) {
                return message.getJMSPriority();
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSStompJmsMessageID", new SubExpression(){

            public Object evaluate(StompJmsMessage message) {
                if (message.getJMSMessageID() == null) {
                    return null;
                }
                return message.getJMSMessageID().toString();
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSTimestamp", new SubExpression(){

            public Object evaluate(StompJmsMessage message) {
                return message.getJMSTimestamp();
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSCorrelationID", new SubExpression(){

            public Object evaluate(StompJmsMessage message) {
                return message.getJMSCorrelationID();
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSExpiration", new SubExpression(){

            public Object evaluate(StompJmsMessage message) {
                return message.getJMSExpiration();
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSRedelivered", new SubExpression(){

            public Object evaluate(StompJmsMessage message) {
                return message.isRedelivered();
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSXDeliveryCount", new SubExpression(){

            public Object evaluate(StompJmsMessage message) {
                return message.getRedeliveryCounter() + 1;
            }
        });
    }

    static interface SubExpression {
        public Object evaluate(StompJmsMessage var1);
    }
}

