/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stomp;

import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.stomp.StompEndpoint;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.support.jsse.SSLContextParameters;

public class StompEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        StompEndpoint target = (StompEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(StompEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "brokerurl": 
            case "brokerURL": {
                target.getConfiguration().setBrokerURL(StompEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "customheaders": 
            case "customHeaders": {
                target.getConfiguration().setCustomHeaders(StompEndpointConfigurer.property(camelContext, Properties.class, value));
                return true;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                target.setExceptionHandler(StompEndpointConfigurer.property(camelContext, ExceptionHandler.class, value));
                return true;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                target.setExchangePattern(StompEndpointConfigurer.property(camelContext, ExchangePattern.class, value));
                return true;
            }
            case "headerfilterstrategy": 
            case "headerFilterStrategy": {
                target.setHeaderFilterStrategy(StompEndpointConfigurer.property(camelContext, HeaderFilterStrategy.class, value));
                return true;
            }
            case "host": {
                target.getConfiguration().setHost(StompEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(StompEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "login": {
                target.getConfiguration().setLogin(StompEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "passcode": {
                target.getConfiguration().setPasscode(StompEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                target.getConfiguration().setSslContextParameters(StompEndpointConfigurer.property(camelContext, SSLContextParameters.class, value));
                return true;
            }
            case "version": {
                target.getConfiguration().setVersion(StompEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "brokerurl": 
            case "brokerURL": {
                return String.class;
            }
            case "customheaders": 
            case "customHeaders": {
                return Properties.class;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return ExceptionHandler.class;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return ExchangePattern.class;
            }
            case "headerfilterstrategy": 
            case "headerFilterStrategy": {
                return HeaderFilterStrategy.class;
            }
            case "host": {
                return String.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "login": {
                return String.class;
            }
            case "passcode": {
                return String.class;
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                return SSLContextParameters.class;
            }
            case "version": {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        StompEndpoint target = (StompEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "brokerurl": 
            case "brokerURL": {
                return target.getConfiguration().getBrokerURL();
            }
            case "customheaders": 
            case "customHeaders": {
                return target.getConfiguration().getCustomHeaders();
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return target.getExceptionHandler();
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return target.getExchangePattern();
            }
            case "headerfilterstrategy": 
            case "headerFilterStrategy": {
                return target.getHeaderFilterStrategy();
            }
            case "host": {
                return target.getConfiguration().getHost();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "login": {
                return target.getConfiguration().getLogin();
            }
            case "passcode": {
                return target.getConfiguration().getPasscode();
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                return target.getConfiguration().getSslContextParameters();
            }
            case "version": {
                return target.getConfiguration().getVersion();
            }
        }
        return null;
    }
}

