/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.tahu;

import java.util.Arrays;
import java.util.List;
import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.tahu.TahuConfiguration;
import org.apache.camel.component.tahu.TahuConstants;
import org.apache.camel.component.tahu.TahuDefaultComponent;
import org.apache.camel.component.tahu.TahuDefaultEndpoint;
import org.apache.camel.component.tahu.TahuEdgeProducer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultHeaderFilterStrategy;
import org.apache.camel.util.ObjectHelper;
import org.eclipse.tahu.message.BdSeqManager;
import org.eclipse.tahu.message.model.DeviceDescriptor;
import org.eclipse.tahu.message.model.EdgeNodeDescriptor;
import org.eclipse.tahu.message.model.SparkplugBPayloadMap;

@UriEndpoint(firstVersion="4.8.0", scheme="tahu-edge", title="Tahu Edge Node / Device", syntax="tahu-edge:groupId/edgeNode", alternativeSyntax="tahu-edge:groupId/edgeNode/deviceId", producerOnly=true, category={Category.MESSAGING, Category.IOT, Category.MONITORING}, headersClass=TahuConstants.class)
public class TahuEdgeEndpoint
extends TahuDefaultEndpoint
implements HeaderFilterStrategyAware {
    @UriPath(label="producer", description="ID of the group")
    @Metadata(applicableFor={"tahu-edge"}, required=true)
    private final String groupId;
    @UriPath(label="producer", description="ID of the edge node")
    @Metadata(applicableFor={"tahu-edge"}, required=true)
    private final String edgeNode;
    @UriPath(label="producer (device only)", description="ID of this edge node device")
    @Metadata(applicableFor={"tahu-edge"})
    private final String deviceId;
    @UriParam(label="producer (edge node only)", description="Host ID of the primary host application for this edge node")
    @Metadata(applicableFor={"tahu-edge"})
    private String primaryHostId;
    @UriParam(label="producer (edge node only)", description="ID of each device connected to this edge node, as a comma-separated list")
    @Metadata(applicableFor={"tahu-edge"})
    private String deviceIds;
    @UriParam(label="producer", description="Tahu SparkplugBPayloadMap to configure metric data types for this edge node or device. Note that this payload is used exclusively as a Sparkplug B spec-compliant configuration for all possible edge node or device metric names, aliases, and data types. This configuration is required to publish proper Sparkplug B NBIRTH and DBIRTH payloads.")
    @Metadata(applicableFor={"tahu-edge"}, required=true)
    private SparkplugBPayloadMap metricDataTypePayloadMap;
    @UriParam(label="producer (edge node only),advanced", description="Flag enabling support for metric aliases", defaultValue="false")
    @Metadata(applicableFor={"tahu-edge"})
    private boolean useAliases = false;
    @UriParam(label="producer,advanced", description="To use a custom HeaderFilterStrategy to filter headers used as Sparkplug metrics", defaultValueNote="Defaults to sending all Camel Message headers with name prefixes of \"CamelTahuMetric.\", including those with null values")
    @Metadata(applicableFor={"tahu-edge"})
    private volatile HeaderFilterStrategy headerFilterStrategy;
    @UriParam(label="producer (edge node only),advanced", description="To use a specific org.eclipse.tahu.message.BdSeqManager implementation to manage edge node birth-death sequence numbers", defaultValue="org.apache.camel.component.tahu.CamelBdSeqManager")
    @Metadata(applicableFor={"tahu-edge"})
    private volatile BdSeqManager bdSeqManager;
    @UriParam(label="producer (edge node only),advanced", description="Path for Sparkplug B NBIRTH/NDEATH sequence number persistence files. This path will contain files named as \"<Edge Node ID>-bdSeqNum\" and must be writable by the executing process' user", defaultValue="${sys:java.io.tmpdir}/CamelTahuTemp")
    @Metadata(applicableFor={"tahu-edge"})
    private String bdSeqNumPath;
    private final EdgeNodeDescriptor edgeNodeDescriptor;

    TahuEdgeEndpoint(String uri, TahuDefaultComponent component, TahuConfiguration configuration, String groupId, String edgeNode, String deviceId) {
        super(uri, component, configuration);
        this.groupId = ObjectHelper.notNullOrEmpty(groupId, "groupId");
        this.edgeNode = ObjectHelper.notNullOrEmpty(edgeNode, "edgeNode");
        this.deviceId = deviceId != null && deviceId.length() == 0 ? null : deviceId;
        this.edgeNodeDescriptor = ObjectHelper.isNotEmpty(deviceId) ? new DeviceDescriptor(groupId, edgeNode, deviceId) : new EdgeNodeDescriptor(groupId, edgeNode);
    }

    @Override
    public Producer createProducer() throws Exception {
        TahuEdgeProducer.Builder producerBuilder = new TahuEdgeProducer.Builder(this).groupId(ObjectHelper.notNullOrEmpty(this.groupId, "groupId")).edgeNode(ObjectHelper.notNullOrEmpty(this.edgeNode, "edgeNode"));
        ObjectHelper.ifNotEmpty(this.deviceId, producerBuilder::deviceId);
        return producerBuilder.build();
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Cannot consume from this endpoint");
    }

    public EdgeNodeDescriptor getEdgeNodeDescriptor() {
        return this.edgeNodeDescriptor;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getEdgeNode() {
        return this.edgeNode;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getPrimaryHostId() {
        return this.primaryHostId;
    }

    public void setPrimaryHostId(String primaryHostId) {
        this.primaryHostId = primaryHostId;
    }

    public String getDeviceIds() {
        return this.deviceIds;
    }

    public void setDeviceIds(String deviceIds) {
        this.deviceIds = deviceIds;
    }

    public List<String> getDeviceIdList() {
        return Arrays.asList(this.deviceIds.split(","));
    }

    public SparkplugBPayloadMap getMetricDataTypePayloadMap() {
        return this.metricDataTypePayloadMap;
    }

    public void setMetricDataTypePayloadMap(SparkplugBPayloadMap metricDataTypePayloadMap) {
        this.metricDataTypePayloadMap = metricDataTypePayloadMap;
    }

    public boolean isUseAliases() {
        return this.useAliases;
    }

    public void setUseAliases(boolean useAliases) {
        this.useAliases = useAliases;
    }

    public BdSeqManager getBdSeqManager() {
        return this.bdSeqManager;
    }

    public void setBdSeqManager(BdSeqManager bdSeqManager) {
        this.bdSeqManager = bdSeqManager;
    }

    public String getBdSeqNumPath() {
        return this.bdSeqNumPath;
    }

    public void setBdSeqNumPath(String bdSeqNumPath) {
        this.bdSeqNumPath = bdSeqNumPath;
    }

    @Override
    public HeaderFilterStrategy getHeaderFilterStrategy() {
        HeaderFilterStrategy existingStrategy = this.headerFilterStrategy;
        if (existingStrategy == null) {
            DefaultHeaderFilterStrategy strategy = new DefaultHeaderFilterStrategy();
            this.headerFilterStrategy = existingStrategy = strategy;
            strategy.setFilterOnMatch(false);
            strategy.setOutFilter((String)null);
            strategy.setOutFilterPattern((String)null);
            strategy.setOutFilterStartsWith("CamelTahuMetric.");
            strategy.setAllowNullValues(true);
        }
        return existingStrategy;
    }

    @Override
    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }
}

