/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.tahu;

import java.util.Arrays;
import java.util.Date;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.TypeConverter;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.TypeConverterRegistry;
import org.eclipse.tahu.SparkplugInvalidTypeException;
import org.eclipse.tahu.message.model.Metric;
import org.eclipse.tahu.message.model.MetricDataType;
import org.eclipse.tahu.message.model.SparkplugBPayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter(generateLoader=true)
public class TahuEdgePayloadConverter
implements HeaderFilterStrategyAware {
    private static final Logger LOG = LoggerFactory.getLogger(TahuEdgePayloadConverter.class);
    private HeaderFilterStrategy headerFilterStrategy;

    @Converter
    public SparkplugBPayload exchangeToSparkplugBPayload(Exchange exchange) {
        LOG.debug("Called exchangeToSparkplugBPayload");
        return this.messageToSparkplugBPayload(exchange.getMessage(), exchange);
    }

    @Converter
    public SparkplugBPayload messageToSparkplugBPayload(Message message, Exchange exchange) {
        TypeConverterRegistry registry;
        TypeConverter converter;
        Message messageCopy = message.copy();
        SparkplugBPayload.SparkplugBPayloadBuilder dataPayloadBuilder = new SparkplugBPayload.SparkplugBPayloadBuilder();
        Date payloadDate = this.getPayloadDate(exchange, messageCopy, dataPayloadBuilder);
        dataPayloadBuilder.setTimestamp(payloadDate);
        Object body = messageCopy.getBody();
        if (body != null && body != message && (converter = (registry = exchange.getContext().getTypeConverterRegistry()).lookup(byte[].class, body.getClass())) != null) {
            byte[] valueBytes = converter.convertTo(byte[].class, body);
            dataPayloadBuilder.setBody(valueBytes);
        }
        messageCopy.getHeaders().forEach((headerName, headerValue) -> {
            if (!this.skipMetricHeader((String)headerName, headerValue, exchange)) {
                if (headerName.equals("CamelTahuMessageUUID")) {
                    dataPayloadBuilder.setUuid(headerValue.toString());
                } else if (headerValue instanceof Metric) {
                    Metric metricValue = (Metric)headerValue;
                    dataPayloadBuilder.addMetric(metricValue);
                } else if (headerName.startsWith("CamelTahuMetric.")) {
                    String metricName = headerName;
                    if (metricName.startsWith("CamelTahuMetric.")) {
                        metricName = metricName.substring("CamelTahuMetric.".length());
                    }
                    try {
                        MetricDataType defaultType = TahuEdgePayloadConverter.getDefaultMetricDataType(headerValue);
                        Metric metric = new Metric.MetricBuilder(metricName, defaultType, headerValue).createMetric();
                        metric.setTimestamp(payloadDate);
                        dataPayloadBuilder.addMetric(metric);
                    }
                    catch (SparkplugInvalidTypeException site) {
                        exchange.setException(site);
                    }
                }
            }
        });
        return dataPayloadBuilder.createPayload();
    }

    private Date getPayloadDate(Exchange exchange, Message messageCopy, SparkplugBPayload.SparkplugBPayloadBuilder dataPayloadBuilder) {
        long payloadTimestamp = messageCopy != null && messageCopy.getMessageTimestamp() != 0L ? messageCopy.getMessageTimestamp() : (exchange.getClock().getCreated() != 0L ? exchange.getClock().getCreated() : System.currentTimeMillis());
        return new Date(payloadTimestamp);
    }

    private static MetricDataType getDefaultMetricDataType(Object headerValue) {
        if (headerValue == null) {
            return MetricDataType.Unknown;
        }
        MetricDataType defaultType = MetricDataTypeStreamHolder.getStream().dropWhile(checkType -> !checkType.getClazz().isAssignableFrom(headerValue.getClass())).findFirst().orElse(MetricDataType.Unknown);
        return defaultType;
    }

    private boolean skipMetricHeader(String headerName, Object headerValue, Exchange exchange) {
        return this.headerFilterStrategy != null && this.headerFilterStrategy.applyFilterToCamelHeaders(headerName, headerValue, exchange);
    }

    @Override
    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    @Override
    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }

    private static class MetricDataTypeStreamHolder {
        private static int[] VALUES = IntStream.range(1, 35).filter(i -> i != 20 && i != 21).toArray();

        private MetricDataTypeStreamHolder() {
        }

        private static Stream<MetricDataType> getStream() {
            return Arrays.stream(VALUES).mapToObj(MetricDataType::fromInteger);
        }
    }
}

