/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.tahu.handlers;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.camel.component.tahu.TahuException;
import org.apache.camel.component.tahu.handlers.TahuEdgeClient;
import org.eclipse.tahu.edge.api.MetricHandler;
import org.eclipse.tahu.message.BdSeqManager;
import org.eclipse.tahu.message.SparkplugBPayloadEncoder;
import org.eclipse.tahu.message.model.DeviceDescriptor;
import org.eclipse.tahu.message.model.EdgeNodeDescriptor;
import org.eclipse.tahu.message.model.MessageType;
import org.eclipse.tahu.message.model.Metric;
import org.eclipse.tahu.message.model.MetricDataType;
import org.eclipse.tahu.message.model.SparkplugBPayload;
import org.eclipse.tahu.message.model.SparkplugBPayloadMap;
import org.eclipse.tahu.message.model.SparkplugDescriptor;
import org.eclipse.tahu.message.model.Topic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

class TahuEdgeMetricHandler
implements MetricHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TahuEdgeMetricHandler.class);
    private final BdSeqManager bdSeqManager;
    private volatile long currentBirthBdSeq;
    private volatile long currentDeathBdSeq;
    private TahuEdgeClient client;
    private final EdgeNodeDescriptor edgeNodeDescriptor;
    private final ConcurrentMap<SparkplugDescriptor, SparkplugBPayloadMap> descriptorMetricMap = new ConcurrentHashMap<SparkplugDescriptor, SparkplugBPayloadMap>();
    private final Marker loggingMarker;

    TahuEdgeMetricHandler(EdgeNodeDescriptor edgeNodeDescriptor, BdSeqManager bdSeqManager) {
        this.edgeNodeDescriptor = edgeNodeDescriptor;
        this.bdSeqManager = bdSeqManager;
        this.loggingMarker = MarkerFactory.getMarker((String)edgeNodeDescriptor.getDescriptorString());
        this.currentBirthBdSeq = this.currentDeathBdSeq = bdSeqManager.getNextDeathBdSeqNum();
    }

    void setClient(TahuEdgeClient client) {
        this.client = client;
    }

    @Override
    public Topic getDeathTopic() {
        return new Topic("spBv1.0", this.edgeNodeDescriptor, MessageType.NDEATH);
    }

    @Override
    public byte[] getDeathPayloadBytes() throws Exception {
        this.currentDeathBdSeq &= 0xFFL;
        SparkplugBPayload deathPayload = new SparkplugBPayload.SparkplugBPayloadBuilder().addMetric(new Metric.MetricBuilder("bdSeq", MetricDataType.Int64, (Object)this.currentDeathBdSeq).createMetric()).createPayload();
        LOG.debug(this.loggingMarker, "Created death payload with bdSeq metric {}", (Object)this.currentDeathBdSeq);
        this.currentBirthBdSeq = this.currentDeathBdSeq++;
        this.bdSeqManager.storeNextDeathBdSeqNum(this.currentDeathBdSeq);
        SparkplugBPayloadEncoder encoder = new SparkplugBPayloadEncoder();
        return encoder.getBytes(deathPayload, true);
    }

    @Override
    public boolean hasMetric(SparkplugDescriptor sparkplugDescriptor, String metricName) {
        return this.descriptorMetricMap.containsKey(sparkplugDescriptor) && ((SparkplugBPayloadMap)this.descriptorMetricMap.get(sparkplugDescriptor)).getMetric(metricName) != null;
    }

    @Override
    public void publishBirthSequence() {
        try {
            Date timestamp = new Date();
            SparkplugBPayloadMap nBirthPayload = new SparkplugBPayloadMap.SparkplugBPayloadMapBuilder().setTimestamp(timestamp).addMetrics(this.getCachedMetrics(this.edgeNodeDescriptor)).addMetric(new Metric.MetricBuilder("bdSeq", MetricDataType.Int64, (Object)this.currentBirthBdSeq).createMetric()).createPayload();
            LOG.debug(this.loggingMarker, "Created birth payload with bdSeq metric {}", (Object)this.currentBirthBdSeq);
            this.client.publishNodeBirth(nBirthPayload);
            this.descriptorMetricMap.keySet().stream().filter(sd -> sd.isDeviceDescriptor()).forEach(sd -> {
                DeviceDescriptor deviceDescriptor = (DeviceDescriptor)sd;
                String deviceId = deviceDescriptor.getDeviceId();
                SparkplugBPayload dBirthPayload = new SparkplugBPayload.SparkplugBPayloadBuilder().setTimestamp(timestamp).addMetrics(this.getCachedMetrics(deviceDescriptor)).createPayload();
                this.client.publishDeviceBirth(deviceId, dBirthPayload);
            });
        }
        catch (Exception e) {
            throw new TahuException(this.edgeNodeDescriptor, "Exception caught publishing birth sequence", e);
        }
    }

    SparkplugBPayloadMap addDeviceMetricDataPayloadMap(SparkplugDescriptor metricDescriptor, SparkplugBPayloadMap metricDataTypePayloadMap) {
        return this.descriptorMetricMap.put(metricDescriptor, metricDataTypePayloadMap);
    }

    List<Metric> getCachedMetrics(SparkplugDescriptor sd) {
        return Optional.ofNullable((SparkplugBPayloadMap)this.descriptorMetricMap.get(sd)).map(SparkplugBPayloadMap::getMetrics).orElse(List.of());
    }

    SparkplugBPayloadMap getDescriptorMetricMap(SparkplugDescriptor sd) {
        return (SparkplugBPayloadMap)this.descriptorMetricMap.get(sd);
    }

    void updateCachedMetrics(SparkplugDescriptor sd, SparkplugBPayload payload) {
        Optional.ofNullable((SparkplugBPayloadMap)this.descriptorMetricMap.get(sd)).ifPresent(cachedMetrics -> payload.getMetrics().stream().forEach(payloadMetric -> cachedMetrics.updateMetricValue(payloadMetric.getName(), (Metric)payloadMetric, null)));
    }

    long getCurrentBirthBdSeq() {
        LOG.trace(this.loggingMarker, "getCurrentBirthBdSeq() : {}", (Object)this.currentBirthBdSeq);
        return this.currentBirthBdSeq;
    }

    long getCurrentDeathBdSeq() {
        LOG.trace(this.loggingMarker, "getCurrentDeathBdSeq() : {}", (Object)this.currentDeathBdSeq);
        return this.currentDeathBdSeq;
    }

    List<Metric> processCMDMetrics(SparkplugBPayload payload, SparkplugDescriptor cmdDescriptor) {
        SparkplugBPayloadMap cachedMetrics;
        List<Metric> receivedMetrics = payload.getMetrics();
        if (receivedMetrics == null || receivedMetrics.isEmpty()) {
            return List.of();
        }
        if (!cmdDescriptor.isDeviceDescriptor()) {
            Map<Boolean, List<Metric>> groupedMetrics = receivedMetrics.stream().collect(Collectors.groupingBy(m -> Boolean.valueOf("Node Control/Rebirth".equals(m.getName())) != false && m.getDataType() == MetricDataType.Boolean && (Boolean)m.getValue() != false));
            if (groupedMetrics.containsKey(Boolean.TRUE) && !groupedMetrics.get(Boolean.TRUE).isEmpty()) {
                this.client.handleRebirthRequest(true);
            }
            receivedMetrics = groupedMetrics.get(Boolean.FALSE);
        }
        if ((cachedMetrics = (SparkplugBPayloadMap)this.descriptorMetricMap.get(cmdDescriptor)) == null) {
            return List.of();
        }
        return receivedMetrics.stream().map(m -> this.getCachedMetric(m.getName(), cachedMetrics, cmdDescriptor)).filter(Objects::nonNull).toList();
    }

    private Metric getCachedMetric(String metricName, SparkplugBPayloadMap cachedMetrics, SparkplugDescriptor cmdDescriptor) {
        Metric cachedMetric = cachedMetrics.getMetric(metricName);
        if (cachedMetric == null) {
            LOG.warn(this.loggingMarker, "Received CMD request for {} metric {} not in configured metrics - skipping", (Object)cmdDescriptor, (Object)metricName);
            return null;
        }
        try {
            Metric responseMetric = new Metric(cachedMetric);
            responseMetric.setHistorical(true);
            return responseMetric;
        }
        catch (Exception e) {
            LOG.warn(this.loggingMarker, "Exception caught copying metric handling CMD request for {} metric {} - skipping", (Object)cmdDescriptor, (Object)metricName);
            return null;
        }
    }
}

