/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.tahu.handlers;

import java.util.function.BiConsumer;
import org.eclipse.tahu.host.api.HostApplicationEventHandler;
import org.eclipse.tahu.message.model.DeviceDescriptor;
import org.eclipse.tahu.message.model.EdgeNodeDescriptor;
import org.eclipse.tahu.message.model.Message;
import org.eclipse.tahu.message.model.Metric;
import org.eclipse.tahu.message.model.SparkplugDescriptor;

public class TahuHostApplicationEventHandler
implements HostApplicationEventHandler {
    private final BiConsumer<EdgeNodeDescriptor, Message> onMessageConsumer;
    private final BiConsumer<EdgeNodeDescriptor, Metric> onMetricConsumer;

    TahuHostApplicationEventHandler(BiConsumer<EdgeNodeDescriptor, Message> onMessageConsumer, BiConsumer<EdgeNodeDescriptor, Metric> onMetricConsumer) {
        this.onMessageConsumer = onMessageConsumer;
        this.onMetricConsumer = onMetricConsumer;
    }

    @Override
    public void onNodeBirthArrived(EdgeNodeDescriptor edgeNodeDescriptor, Message message) {
        this.onMessageConsumer.accept(edgeNodeDescriptor, message);
    }

    @Override
    public void onNodeBirthComplete(EdgeNodeDescriptor edgeNodeDescriptor) {
    }

    @Override
    public void onNodeDataArrived(EdgeNodeDescriptor edgeNodeDescriptor, Message message) {
        this.onMessageConsumer.accept(edgeNodeDescriptor, message);
    }

    @Override
    public void onNodeDataComplete(EdgeNodeDescriptor edgeNodeDescriptor) {
    }

    @Override
    public void onNodeDeath(EdgeNodeDescriptor edgeNodeDescriptor, Message message) {
        this.onMessageConsumer.accept(edgeNodeDescriptor, message);
    }

    @Override
    public void onNodeDeathComplete(EdgeNodeDescriptor edgeNodeDescriptor) {
    }

    @Override
    public void onDeviceBirthArrived(DeviceDescriptor deviceDescriptor, Message message) {
        this.onMessageConsumer.accept(deviceDescriptor, message);
    }

    @Override
    public void onDeviceBirthComplete(DeviceDescriptor deviceDescriptor) {
    }

    @Override
    public void onDeviceDataArrived(DeviceDescriptor deviceDescriptor, Message message) {
        this.onMessageConsumer.accept(deviceDescriptor, message);
    }

    @Override
    public void onDeviceDataComplete(DeviceDescriptor deviceDescriptor) {
    }

    @Override
    public void onDeviceDeath(DeviceDescriptor deviceDescriptor, Message message) {
        this.onMessageConsumer.accept(deviceDescriptor, message);
    }

    @Override
    public void onDeviceDeathComplete(DeviceDescriptor deviceDescriptor) {
    }

    @Override
    public void onBirthMetric(SparkplugDescriptor sparkplugDescriptor, Metric metric) {
        this.acceptMetric(sparkplugDescriptor, metric);
    }

    @Override
    public void onDataMetric(SparkplugDescriptor sparkplugDescriptor, Metric metric) {
        this.acceptMetric(sparkplugDescriptor, metric);
    }

    @Override
    public void onStale(SparkplugDescriptor sparkplugDescriptor, Metric metric) {
        this.acceptMetric(sparkplugDescriptor, metric);
    }

    @Override
    public void onMessage(SparkplugDescriptor sparkplugDescriptor, Message message) {
        if (sparkplugDescriptor.isDeviceDescriptor()) {
            this.onMessageConsumer.accept((DeviceDescriptor)sparkplugDescriptor, message);
        } else {
            this.onMessageConsumer.accept((EdgeNodeDescriptor)sparkplugDescriptor, message);
        }
    }

    private void acceptMetric(SparkplugDescriptor sparkplugDescriptor, Metric metric) {
        if (sparkplugDescriptor.isDeviceDescriptor()) {
            this.onMetricConsumer.accept((DeviceDescriptor)sparkplugDescriptor, metric);
        } else {
            this.onMetricConsumer.accept((EdgeNodeDescriptor)sparkplugDescriptor, metric);
        }
    }

    @Override
    public void onConnect() {
    }

    @Override
    public void onDisconnect() {
    }
}

