/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.edge;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.tahu.message.model.EdgeNodeDescriptor;
import org.eclipse.tahu.message.model.Metric;
import org.eclipse.tahu.message.model.MetricDataType;
import org.eclipse.tahu.message.model.SparkplugDescriptor;
import org.eclipse.tahu.message.model.Template;
import org.eclipse.tahu.model.MetricDataTypeMap;
import org.eclipse.tahu.model.MetricMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdgeNodeMetricMaps {
    private static Logger logger = LoggerFactory.getLogger((String)EdgeNodeMetricMaps.class.getName());
    private static Map<String, EdgeNodeMetricMaps> instances;
    private final Map<EdgeNodeDescriptor, Map<SparkplugDescriptor, MetricMap>> allEdgeNodeMetricMaps;
    private final Object mapLock = new Object();

    public static EdgeNodeMetricMaps getInstance(String agentName) {
        if (instances == null) {
            instances = new ConcurrentHashMap<String, EdgeNodeMetricMaps>();
        }
        if (instances.get(agentName) == null) {
            instances.put(agentName, new EdgeNodeMetricMaps());
        }
        return instances.get(agentName);
    }

    private EdgeNodeMetricMaps() {
        this.allEdgeNodeMetricMaps = new ConcurrentHashMap<EdgeNodeDescriptor, Map<SparkplugDescriptor, MetricMap>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMetric(EdgeNodeDescriptor edgeNodeDescriptor, SparkplugDescriptor sparkplugDescriptor, String metricName, Metric metric) {
        Object object = this.mapLock;
        synchronized (object) {
            Map edgeNodeMetricMaps = this.allEdgeNodeMetricMaps.computeIfAbsent(edgeNodeDescriptor, k -> new ConcurrentHashMap());
            MetricMap metricMap = edgeNodeMetricMaps.computeIfAbsent(sparkplugDescriptor, k -> new MetricMap());
            metricMap.addAlias(metricName, metric.getAlias(), metric.getDataType());
            if (metric.getDataType() == MetricDataType.Template && metric.getValue() != null && Template.class.isAssignableFrom(metric.getValue().getClass())) {
                Template template = (Template)metric.getValue();
                for (Metric childMetric : template.getMetrics()) {
                    this.addMetric(edgeNodeDescriptor, sparkplugDescriptor, metricName + "/" + childMetric.getName(), childMetric);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mapLock;
        synchronized (object) {
            this.allEdgeNodeMetricMaps.clear();
        }
    }

    public Long getAlias(EdgeNodeDescriptor edgeNodeDescriptor, SparkplugDescriptor sparkplugDescriptor, String metricName) {
        Map<SparkplugDescriptor, MetricMap> edgeNodeMetricMaps = this.allEdgeNodeMetricMaps.get(edgeNodeDescriptor);
        if (edgeNodeMetricMaps != null) {
            MetricMap metricMap = edgeNodeMetricMaps.get(sparkplugDescriptor);
            if (metricMap != null) {
                return metricMap.getAlias(metricName);
            }
            return null;
        }
        return null;
    }

    public String getMetricName(EdgeNodeDescriptor edgeNodeDescriptor, SparkplugDescriptor sparkplugDescriptor, long alias) {
        Map<SparkplugDescriptor, MetricMap> edgeNodeMetricMaps = this.allEdgeNodeMetricMaps.get(edgeNodeDescriptor);
        if (edgeNodeMetricMaps != null) {
            MetricMap metricMap = edgeNodeMetricMaps.get(sparkplugDescriptor);
            if (metricMap != null) {
                return metricMap.getMetricName(alias);
            }
            return null;
        }
        return null;
    }

    public boolean aliasExists(EdgeNodeDescriptor edgeNodeDescriptor, SparkplugDescriptor sparkplugDescriptor, long alias) {
        Map<SparkplugDescriptor, MetricMap> edgeNodeMetricMaps = this.allEdgeNodeMetricMaps.get(edgeNodeDescriptor);
        if (edgeNodeMetricMaps != null && edgeNodeMetricMaps.get(sparkplugDescriptor) != null) {
            MetricMap metricMap = edgeNodeMetricMaps.get(sparkplugDescriptor);
            return metricMap != null && metricMap.getMetricName(alias) != null;
        }
        return false;
    }

    public MetricDataTypeMap getMetricDataTypeMap(EdgeNodeDescriptor edgeNodeDescriptor, SparkplugDescriptor sparkplugDescriptor) {
        Map edgeNodeMetricMaps = this.allEdgeNodeMetricMaps.computeIfAbsent(edgeNodeDescriptor, k -> new ConcurrentHashMap());
        edgeNodeMetricMaps.computeIfAbsent(sparkplugDescriptor, k -> new MetricMap());
        return ((MetricMap)edgeNodeMetricMaps.get(sparkplugDescriptor)).getMetricDataTypeMap();
    }

    public MetricDataType getDataType(EdgeNodeDescriptor edgeNodeDescriptor, SparkplugDescriptor sparkplugDescriptor, String metricName) {
        Map<SparkplugDescriptor, MetricMap> edgeNodeMetricMaps = this.allEdgeNodeMetricMaps.get(edgeNodeDescriptor);
        if (edgeNodeMetricMaps != null && edgeNodeMetricMaps.get(sparkplugDescriptor) != null) {
            return edgeNodeMetricMaps.get(sparkplugDescriptor).getMetricDataType(metricName);
        }
        return null;
    }

    public MetricDataType getDataType(EdgeNodeDescriptor edgeNodeDescriptor, SparkplugDescriptor sparkplugDescriptor, Long alias) {
        Map<SparkplugDescriptor, MetricMap> edgeNodeMetricMaps = this.allEdgeNodeMetricMaps.get(edgeNodeDescriptor);
        if (edgeNodeMetricMaps != null && edgeNodeMetricMaps.get(sparkplugDescriptor) != null) {
            return edgeNodeMetricMaps.get(sparkplugDescriptor).getMetricDataType(alias);
        }
        return null;
    }
}

