/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.host.manager;

import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.tahu.exception.TahuErrorCode;
import org.eclipse.tahu.exception.TahuException;
import org.eclipse.tahu.host.manager.SparkplugDevice;
import org.eclipse.tahu.host.manager.SparkplugEdgeNode;
import org.eclipse.tahu.message.model.DeviceDescriptor;
import org.eclipse.tahu.message.model.EdgeNodeDescriptor;
import org.eclipse.tahu.mqtt.MqttClientId;
import org.eclipse.tahu.mqtt.MqttServerName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdgeNodeManager {
    private static Logger logger = LoggerFactory.getLogger((String)EdgeNodeManager.class.getName());
    private static EdgeNodeManager instance;
    private Map<EdgeNodeDescriptor, SparkplugEdgeNode> edgeNodeMap;
    private final Object lock = new Object();

    private EdgeNodeManager() {
        this.edgeNodeMap = new ConcurrentHashMap<EdgeNodeDescriptor, SparkplugEdgeNode>();
    }

    public static EdgeNodeManager getInstance() {
        if (instance == null) {
            instance = new EdgeNodeManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SparkplugEdgeNode getSparkplugEdgeNode(EdgeNodeDescriptor edgeNodeDescriptor) {
        Object object = this.lock;
        synchronized (object) {
            return this.edgeNodeMap.get(edgeNodeDescriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SparkplugEdgeNode addSparkplugEdgeNode(EdgeNodeDescriptor edgeNodeDescriptor, MqttServerName mqttServerName, MqttClientId hostAppMqttClientId) {
        Object object = this.lock;
        synchronized (object) {
            SparkplugEdgeNode sparkplugEdgeNode = new SparkplugEdgeNode(edgeNodeDescriptor, mqttServerName, hostAppMqttClientId);
            this.edgeNodeMap.put(edgeNodeDescriptor, sparkplugEdgeNode);
            return sparkplugEdgeNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SparkplugDevice getSparkplugDevice(EdgeNodeDescriptor edgeNodeDescriptor, DeviceDescriptor deviceDescriptor) {
        Object object = this.lock;
        synchronized (object) {
            SparkplugEdgeNode sparkplugEdgeNode = this.edgeNodeMap.get(edgeNodeDescriptor);
            if (sparkplugEdgeNode != null) {
                return sparkplugEdgeNode.getSparkplugDevice(deviceDescriptor);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SparkplugDevice addSparkplugDevice(EdgeNodeDescriptor edgeNodeDescriptor, DeviceDescriptor deviceDescriptor, Date onlineTimestamp) throws TahuException {
        Object object = this.lock;
        synchronized (object) {
            SparkplugEdgeNode sparkplugEdgeNode = this.edgeNodeMap.get(edgeNodeDescriptor);
            if (sparkplugEdgeNode == null) {
                throw new TahuException(TahuErrorCode.INITIALIZATION_ERROR, "The SparkplugEdgeNode must already exist before adding a device");
            }
            SparkplugDevice sparkplugDevice = new SparkplugDevice(sparkplugEdgeNode, deviceDescriptor, onlineTimestamp);
            sparkplugEdgeNode.addDevice(deviceDescriptor, sparkplugDevice);
            return sparkplugDevice;
        }
    }
}

