/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.message.model;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.Objects;
import org.eclipse.tahu.SparkplugInvalidTypeException;
import org.eclipse.tahu.message.model.ParameterDataType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Parameter {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="type")
    private ParameterDataType type;
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Object value;

    public Parameter() {
    }

    public Parameter(String name, ParameterDataType type, Object value) throws SparkplugInvalidTypeException {
        this.name = name;
        this.type = type;
        this.value = value;
        if (value != null) {
            this.type.checkType(value);
        }
    }

    public Parameter(Parameter parameter) throws SparkplugInvalidTypeException {
        this.name = parameter.getName();
        this.type = parameter.getType();
        this.value = parameter.getValue();
        if (this.value != null) {
            this.type.checkType(this.value);
        }
    }

    @JsonGetter(value="name")
    public String getName() {
        return this.name;
    }

    @JsonSetter(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public ParameterDataType getType() {
        return this.type;
    }

    public void setType(ParameterDataType type) {
        this.type = type;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Parameter param = (Parameter)object;
        return Objects.equals(this.name, param.getName()) && Objects.equals(this.type, param.getType()) && Objects.equals(this.value, param.getValue());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Parameter [name=");
        builder.append(this.name);
        builder.append(", type=");
        builder.append(this.type);
        builder.append(", value=");
        builder.append(this.value);
        builder.append("]");
        return builder.toString();
    }
}

