/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.model;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.tahu.message.model.MetricDataType;
import org.eclipse.tahu.model.MetricDataTypeMap;

public class MetricMap {
    private final Map<String, Long> metricNameToAliasMap;
    private final Map<Long, String> aliasToMetricNameMap;
    private final MetricDataTypeMap metricDataTypeMap;
    private long nextAliasIndex = 0L;
    private final Object mapLock = new Object();

    public MetricMap() {
        this.metricNameToAliasMap = new ConcurrentHashMap<String, Long>();
        this.aliasToMetricNameMap = new ConcurrentHashMap<Long, String>();
        this.metricDataTypeMap = new MetricDataTypeMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long addGeneratedAlias(String metricName, MetricDataType metricDataType) {
        Object object = this.mapLock;
        synchronized (object) {
            long newAlias = this.nextAliasIndex++;
            this.metricNameToAliasMap.put(metricName, newAlias);
            this.aliasToMetricNameMap.put(newAlias, metricName);
            this.metricDataTypeMap.addMetricDataType(metricName, metricDataType);
            return newAlias;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAlias(String metricName, Long alias, MetricDataType metricDataType) {
        Object object = this.mapLock;
        synchronized (object) {
            if (alias != null) {
                this.metricNameToAliasMap.put(metricName, alias);
                this.aliasToMetricNameMap.put(alias, metricName);
                this.metricDataTypeMap.addMetricDataType(alias, metricDataType);
            }
            this.metricDataTypeMap.addMetricDataType(metricName, metricDataType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mapLock;
        synchronized (object) {
            this.metricNameToAliasMap.clear();
            this.aliasToMetricNameMap.clear();
            this.metricDataTypeMap.clear();
            this.nextAliasIndex = 0L;
        }
    }

    public Long getAlias(String metricName) {
        return this.metricNameToAliasMap.get(metricName);
    }

    public String getMetricName(long alias) {
        return this.aliasToMetricNameMap.get(alias);
    }

    public MetricDataType getMetricDataType(String metricName) {
        return this.metricDataTypeMap.getMetricDataType(metricName);
    }

    public MetricDataType getMetricDataType(Long alias) {
        return this.metricDataTypeMap.getMetricDataType(alias);
    }

    public MetricDataTypeMap getMetricDataTypeMap() {
        return this.metricDataTypeMap;
    }
}

