/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.thrift;

import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.thrift.ThriftCompressionType;
import org.apache.camel.component.thrift.ThriftEndpoint;
import org.apache.camel.component.thrift.ThriftExchangeProtocol;
import org.apache.camel.component.thrift.ThriftNegotiationType;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.support.jsse.SSLContextParameters;

public class ThriftEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        ThriftEndpoint target = (ThriftEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(ThriftEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "clienttimeout": 
            case "clientTimeout": {
                target.getConfiguration().setClientTimeout(ThriftEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "compressiontype": 
            case "compressionType": {
                target.getConfiguration().setCompressionType(ThriftEndpointConfigurer.property(camelContext, ThriftCompressionType.class, value));
                return true;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                target.setExceptionHandler(ThriftEndpointConfigurer.property(camelContext, ExceptionHandler.class, value));
                return true;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                target.setExchangePattern(ThriftEndpointConfigurer.property(camelContext, ExchangePattern.class, value));
                return true;
            }
            case "exchangeprotocol": 
            case "exchangeProtocol": {
                target.getConfiguration().setExchangeProtocol(ThriftEndpointConfigurer.property(camelContext, ThriftExchangeProtocol.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(ThriftEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "maxpoolsize": 
            case "maxPoolSize": {
                target.getConfiguration().setMaxPoolSize(ThriftEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "method": {
                target.getConfiguration().setMethod(ThriftEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "negotiationtype": 
            case "negotiationType": {
                target.getConfiguration().setNegotiationType(ThriftEndpointConfigurer.property(camelContext, ThriftNegotiationType.class, value));
                return true;
            }
            case "poolsize": 
            case "poolSize": {
                target.getConfiguration().setPoolSize(ThriftEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "sslparameters": 
            case "sslParameters": {
                target.getConfiguration().setSslParameters(ThriftEndpointConfigurer.property(camelContext, SSLContextParameters.class, value));
                return true;
            }
            case "synchronous": {
                target.setSynchronous(ThriftEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "clienttimeout": 
            case "clientTimeout": {
                return Integer.TYPE;
            }
            case "compressiontype": 
            case "compressionType": {
                return ThriftCompressionType.class;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return ExceptionHandler.class;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return ExchangePattern.class;
            }
            case "exchangeprotocol": 
            case "exchangeProtocol": {
                return ThriftExchangeProtocol.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "maxpoolsize": 
            case "maxPoolSize": {
                return Integer.TYPE;
            }
            case "method": {
                return String.class;
            }
            case "negotiationtype": 
            case "negotiationType": {
                return ThriftNegotiationType.class;
            }
            case "poolsize": 
            case "poolSize": {
                return Integer.TYPE;
            }
            case "sslparameters": 
            case "sslParameters": {
                return SSLContextParameters.class;
            }
            case "synchronous": {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        ThriftEndpoint target = (ThriftEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "clienttimeout": 
            case "clientTimeout": {
                return target.getConfiguration().getClientTimeout();
            }
            case "compressiontype": 
            case "compressionType": {
                return target.getConfiguration().getCompressionType();
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return target.getExceptionHandler();
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return target.getExchangePattern();
            }
            case "exchangeprotocol": 
            case "exchangeProtocol": {
                return target.getConfiguration().getExchangeProtocol();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "maxpoolsize": 
            case "maxPoolSize": {
                return target.getConfiguration().getMaxPoolSize();
            }
            case "method": {
                return target.getConfiguration().getMethod();
            }
            case "negotiationtype": 
            case "negotiationType": {
                return target.getConfiguration().getNegotiationType();
            }
            case "poolsize": 
            case "poolSize": {
                return target.getConfiguration().getPoolSize();
            }
            case "sslparameters": 
            case "sslParameters": {
                return target.getConfiguration().getSslParameters();
            }
            case "synchronous": {
                return target.isSynchronous();
            }
        }
        return null;
    }
}

