/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.processor;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.RestClientRequestValidator;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.ResolverHelper;
import org.apache.camel.support.processor.DefaultRestClientRequestValidator;
import org.apache.camel.support.processor.RestBindingAdvice;
import org.apache.camel.support.processor.RestBindingConfiguration;

public class RestBindingAdviceFactory {
    public static RestBindingAdvice build(CamelContext camelContext, RestBindingConfiguration bc) throws Exception {
        String mode = bc.getBindingMode();
        RestConfiguration config = camelContext.getRestConfiguration();
        DataFormat json = null;
        DataFormat outJson = null;
        if (mode.contains("json") || "auto".equals(mode) || bc.isClientRequestValidation()) {
            boolean optional;
            String name = config.getJsonDataFormat();
            if (name != null) {
                Object instance = RestBindingAdviceFactory.lookupByName(camelContext, name);
                if (instance != null) {
                    throw new IllegalArgumentException("JsonDataFormat name: " + name + " must not be an existing bean instance from the registry");
                }
            } else {
                name = "jackson";
            }
            boolean bl = optional = "off".equals(mode) && bc.isClientRequestValidation();
            if (optional) {
                try {
                    json = camelContext.createDataFormat(name);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                json = camelContext.createDataFormat(name);
                outJson = camelContext.createDataFormat(name);
            }
            if (json != null) {
                RestBindingAdviceFactory.setupJson(camelContext, config, bc.getType(), bc.getTypeClass(), bc.getOutType(), bc.getOutTypeClass(), json, outJson);
            }
        }
        DataFormat jaxb = null;
        DataFormat outJaxb = null;
        if (mode.contains("xml") || "auto".equals(mode)) {
            String name = config.getXmlDataFormat();
            if (name != null) {
                Object instance = RestBindingAdviceFactory.lookupByName(camelContext, name);
                if (instance != null) {
                    throw new IllegalArgumentException("XmlDataFormat name: " + name + " must not be an existing bean instance from the registry");
                }
            } else {
                name = "jaxb";
            }
            jaxb = camelContext.createDataFormat(name);
            outJaxb = camelContext.createDataFormat(name);
            if (mode.contains("xml") && jaxb == null) {
                throw new IllegalArgumentException("XML DataFormat " + name + " not found.");
            }
            if (jaxb != null) {
                PluginHelper.getRestBindingJaxbDataFormatFactory(camelContext).setupJaxb(camelContext, config, bc.getType(), bc.getTypeClass(), bc.getOutType(), bc.getOutTypeClass(), jaxb, outJaxb);
            }
        }
        RestClientRequestValidator validator = null;
        if (bc.isClientRequestValidation()) {
            validator = RestBindingAdviceFactory.lookupRestClientRequestValidator(camelContext);
        }
        return new RestBindingAdvice(camelContext, json, jaxb, outJson, outJaxb, bc.getConsumes(), bc.getProduces(), mode, bc.isSkipBindingOnErrorCode(), bc.isClientRequestValidation(), bc.isEnableCORS(), bc.isEnableNoContentResponse(), bc.getCorsHeaders(), bc.getQueryDefaultValues(), bc.getQueryAllowedValues(), bc.isRequiredBody(), bc.getRequiredQueryParameters(), bc.getRequiredHeaders(), validator);
    }

    protected static void setupJson(CamelContext camelContext, RestConfiguration config, String type, Class<?> typeClass, String outType, Class<?> outTypeClass, DataFormat json, DataFormat outJson) throws Exception {
        Class<?> clazz = null;
        boolean useList = false;
        if (typeClass != null) {
            useList = typeClass.isArray();
            clazz = useList ? typeClass.getComponentType() : typeClass;
        } else if (type != null) {
            useList = type.endsWith("[]");
            String typeName = useList ? type.substring(0, type.length() - 2) : type;
            clazz = camelContext.getClassResolver().resolveMandatoryClass(typeName);
        }
        BeanIntrospection beanIntrospection = PluginHelper.getBeanIntrospection(camelContext);
        if (clazz != null) {
            beanIntrospection.setProperty(camelContext, json, "unmarshalType", clazz);
            beanIntrospection.setProperty(camelContext, json, "useList", useList);
        }
        RestBindingAdviceFactory.setAdditionalConfiguration(camelContext, config, json, "json.in.");
        if (outJson != null) {
            Class<?> outClazz = null;
            boolean outUseList = false;
            if (outTypeClass != null) {
                outUseList = outTypeClass.isArray();
                outClazz = outUseList ? outTypeClass.getComponentType() : outTypeClass;
            } else if (outType != null) {
                outUseList = outType.endsWith("[]");
                String typeName = outUseList ? outType.substring(0, outType.length() - 2) : outType;
                outClazz = camelContext.getClassResolver().resolveMandatoryClass(typeName);
            }
            if (outClazz != null) {
                beanIntrospection.setProperty(camelContext, outJson, "unmarshalType", outClazz);
                beanIntrospection.setProperty(camelContext, outJson, "useList", outUseList);
            }
            RestBindingAdviceFactory.setAdditionalConfiguration(camelContext, config, outJson, "json.out.");
        }
    }

    protected static RestClientRequestValidator lookupRestClientRequestValidator(CamelContext camelContext) {
        RestClientRequestValidator answer = CamelContextHelper.findSingleByType(camelContext, RestClientRequestValidator.class);
        if (answer == null) {
            Optional<RestClientRequestValidator> result = ResolverHelper.resolveService(camelContext, camelContext.getCamelContextExtension().getBootstrapFactoryFinder(), "rest-client-validator-factory", RestClientRequestValidator.class);
            answer = result.orElseGet(DefaultRestClientRequestValidator::new);
        }
        return answer;
    }

    private static void setAdditionalConfiguration(CamelContext camelContext, RestConfiguration config, DataFormat dataFormat, String prefix) {
        if (config.getDataFormatProperties() != null && !config.getDataFormatProperties().isEmpty()) {
            HashMap<String, Object> copy = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : config.getDataFormatProperties().entrySet()) {
                String key = entry.getKey();
                boolean known = RestBindingAdviceFactory.isKeyKnownPrefix(key);
                String copyKey = known ? key.substring(prefix.length()) : key;
                if (known && !key.startsWith(prefix)) continue;
                copy.put(copyKey, entry.getValue());
            }
            PropertyBindingSupport.build().bind(camelContext, dataFormat, copy);
        }
    }

    private static boolean isKeyKnownPrefix(String key) {
        return key.startsWith("json.in.") || key.startsWith("json.out.") || key.startsWith("xml.in.") || key.startsWith("xml.out.");
    }

    private static Object lookupByName(CamelContext camelContext, String name) {
        if (name == null) {
            return null;
        }
        if (EndpointHelper.isReferenceParameter(name)) {
            return EndpointHelper.resolveReferenceParameter(camelContext, name, Object.class, false);
        }
        return camelContext.getRegistry().lookupByName(name);
    }
}

