/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.processor;

import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.inline.IInliner;
import org.thymeleaf.inline.NoOpInliner;
import org.thymeleaf.standard.inline.StandardCSSInliner;
import org.thymeleaf.standard.inline.StandardHTMLInliner;
import org.thymeleaf.standard.inline.StandardInlineMode;
import org.thymeleaf.standard.inline.StandardJavaScriptInliner;
import org.thymeleaf.standard.inline.StandardTextInliner;
import org.thymeleaf.standard.processor.AbstractStandardTextInlineSettingTagProcessor;
import org.thymeleaf.templatemode.TemplateMode;

public final class StandardInlineHTMLTagProcessor
extends AbstractStandardTextInlineSettingTagProcessor {
    public static final int PRECEDENCE = 1000;
    public static final String ATTR_NAME = "inline";

    public StandardInlineHTMLTagProcessor(String dialectPrefix) {
        super(TemplateMode.HTML, dialectPrefix, ATTR_NAME, 1000);
    }

    @Override
    protected IInliner getInliner(ITemplateContext context, StandardInlineMode inlineMode) {
        switch (inlineMode) {
            case NONE: {
                return NoOpInliner.INSTANCE;
            }
            case HTML: {
                return new StandardHTMLInliner(context.getConfiguration());
            }
            case TEXT: {
                return new StandardTextInliner(context.getConfiguration());
            }
            case JAVASCRIPT: {
                return new StandardJavaScriptInliner(context.getConfiguration());
            }
            case CSS: {
                return new StandardCSSInliner(context.getConfiguration());
            }
        }
        throw new TemplateProcessingException("Invalid inline mode selected: " + (Object)((Object)inlineMode) + ". Allowed inline modes in template mode " + (Object)((Object)this.getTemplateMode()) + " are: \"" + (Object)((Object)StandardInlineMode.HTML) + "\", \"" + (Object)((Object)StandardInlineMode.TEXT) + "\", \"" + (Object)((Object)StandardInlineMode.JAVASCRIPT) + "\", \"" + (Object)((Object)StandardInlineMode.CSS) + "\" and \"" + (Object)((Object)StandardInlineMode.NONE) + "\"");
    }
}

