/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.tika;

import org.apache.camel.CamelContext;
import org.apache.camel.component.tika.TikaEndpoint;
import org.apache.camel.component.tika.TikaParseOutputFormat;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.tika.config.TikaConfig;

public class TikaEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        TikaEndpoint target = (TikaEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(TikaEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "tikaconfig": 
            case "tikaConfig": {
                target.getTikaConfiguration().setTikaConfig(TikaEndpointConfigurer.property(camelContext, TikaConfig.class, value));
                return true;
            }
            case "tikaconfiguri": 
            case "tikaConfigUri": {
                target.getTikaConfiguration().setTikaConfigUri(TikaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "tikaparseoutputencoding": 
            case "tikaParseOutputEncoding": {
                target.getTikaConfiguration().setTikaParseOutputEncoding(TikaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "tikaparseoutputformat": 
            case "tikaParseOutputFormat": {
                target.getTikaConfiguration().setTikaParseOutputFormat(TikaEndpointConfigurer.property(camelContext, TikaParseOutputFormat.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "tikaconfig": 
            case "tikaConfig": {
                return TikaConfig.class;
            }
            case "tikaconfiguri": 
            case "tikaConfigUri": {
                return String.class;
            }
            case "tikaparseoutputencoding": 
            case "tikaParseOutputEncoding": {
                return String.class;
            }
            case "tikaparseoutputformat": 
            case "tikaParseOutputFormat": {
                return TikaParseOutputFormat.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        TikaEndpoint target = (TikaEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "tikaconfig": 
            case "tikaConfig": {
                return target.getTikaConfiguration().getTikaConfig();
            }
            case "tikaconfiguri": 
            case "tikaConfigUri": {
                return target.getTikaConfiguration().getTikaConfigUri();
            }
            case "tikaparseoutputencoding": 
            case "tikaParseOutputEncoding": {
                return target.getTikaConfiguration().getTikaParseOutputEncoding();
            }
            case "tikaparseoutputformat": 
            case "tikaParseOutputFormat": {
                return target.getTikaConfiguration().getTikaParseOutputFormat();
            }
        }
        return null;
    }
}

