/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.spi.UuidGenerator;

public class ShortUuidGenerator
implements UuidGenerator {
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    private final char[] seed = (ShortUuidGenerator.seedToHex(ThreadLocalRandom.current().nextLong()).substring(1) + "-").toCharArray();
    private final AtomicLong index = new AtomicLong();

    @Override
    public String generateUuid() {
        return ShortUuidGenerator.longToHex(this.seed, this.index.getAndIncrement());
    }

    private static String longToHex(char[] seed, long v) {
        int l = seed.length;
        char[] hexChars = new char[16];
        System.arraycopy(seed, 0, hexChars, 0, l);
        for (int j = 9; j >= 0; --j) {
            hexChars[l + j] = HEX_ARRAY[(int)(v & 0xFL)];
            v >>= 4;
        }
        return new String(hexChars);
    }

    private static String seedToHex(long v) {
        char[] hexChars = new char[6];
        for (int j = 5; j >= 0; --j) {
            hexChars[j] = HEX_ARRAY[(int)(v & 0xFL)];
            v >>= 4;
        }
        return new String(hexChars);
    }
}

