/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.timer;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.StartupListener;
import org.apache.camel.Suspendable;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.timer.TimerEndpoint;
import org.apache.camel.support.DefaultConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Managed TimerConsumer")
public class TimerConsumer
extends DefaultConsumer
implements StartupListener,
Suspendable {
    private static final Logger LOG = LoggerFactory.getLogger(TimerConsumer.class);
    private final TimerEndpoint endpoint;
    private volatile TimerTask task;
    private volatile boolean configured;
    private ExecutorService executorService;
    private final AtomicLong counter = new AtomicLong();
    private volatile boolean polling;

    public TimerConsumer(TimerEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.endpoint = endpoint;
    }

    @Override
    public TimerEndpoint getEndpoint() {
        return (TimerEndpoint)super.getEndpoint();
    }

    @ManagedAttribute(description="Total number of polls run")
    public long getCounter() {
        return this.counter.get();
    }

    @ManagedAttribute(description="Whether polling is currently in progress")
    public boolean isPolling() {
        return this.polling;
    }

    @ManagedAttribute(description="Timer Name")
    public String getTimerName() {
        return this.getEndpoint().getTimerName();
    }

    @ManagedAttribute(description="Timer FixedRate")
    public boolean isFixedRate() {
        return this.getEndpoint().isFixedRate();
    }

    @ManagedAttribute(description="Timer Delay")
    public long getDelay() {
        return this.getEndpoint().getDelay();
    }

    @ManagedAttribute(description="Timer Period")
    public long getPeriod() {
        return this.getEndpoint().getPeriod();
    }

    @ManagedAttribute(description="Repeat Count")
    public long getRepeatCount() {
        return this.getEndpoint().getRepeatCount();
    }

    @ManagedAttribute(description="The consumer logs a start/complete log line when it polls. This option allows you to configure the logging level for that.")
    public String getRunLoggingLevel() {
        return this.getEndpoint().getRunLoggingLevel().name();
    }

    @Override
    public void doInit() throws Exception {
        if (this.endpoint.getDelay() >= 0L) {
            this.task = new TimerTask(){

                @Override
                public void run() {
                    if (!TimerConsumer.this.isTaskRunAllowed()) {
                        LOG.debug("Run not allowed for timer: {}", (Object)TimerConsumer.this.endpoint);
                        return;
                    }
                    LoggingLevel runLoggingLevel = TimerConsumer.this.getEndpoint().getRunLoggingLevel();
                    if (LoggingLevel.ERROR == runLoggingLevel) {
                        LOG.error("Timer task started on:   {}", (Object)TimerConsumer.this.getEndpoint());
                    } else if (LoggingLevel.WARN == runLoggingLevel) {
                        LOG.warn("Timer task started on:   {}", (Object)TimerConsumer.this.getEndpoint());
                    } else if (LoggingLevel.INFO == runLoggingLevel) {
                        LOG.info("Timer task started on:   {}", (Object)TimerConsumer.this.getEndpoint());
                    } else if (LoggingLevel.DEBUG == runLoggingLevel) {
                        LOG.debug("Timer task started on:   {}", (Object)TimerConsumer.this.getEndpoint());
                    } else {
                        LOG.trace("Timer task started on:   {}", (Object)TimerConsumer.this.getEndpoint());
                    }
                    try {
                        TimerConsumer.this.polling = true;
                        this.doRun();
                    }
                    catch (Exception e) {
                        LOG.warn("Error processing exchange. This exception will be ignored, to let the timer be able to trigger again.", (Throwable)e);
                    }
                    finally {
                        TimerConsumer.this.polling = false;
                    }
                    if (LoggingLevel.ERROR == runLoggingLevel) {
                        LOG.error("Timer task completed on: {}", (Object)TimerConsumer.this.getEndpoint());
                    } else if (LoggingLevel.WARN == runLoggingLevel) {
                        LOG.warn("Timer task completed on: {}", (Object)TimerConsumer.this.getEndpoint());
                    } else if (LoggingLevel.INFO == runLoggingLevel) {
                        LOG.info("Timer task completed on: {}", (Object)TimerConsumer.this.getEndpoint());
                    } else if (LoggingLevel.DEBUG == runLoggingLevel) {
                        LOG.debug("Timer task completed on: {}", (Object)TimerConsumer.this.getEndpoint());
                    } else {
                        LOG.trace("Timer task completed on: {}", (Object)TimerConsumer.this.getEndpoint());
                    }
                }

                protected void doRun() {
                    boolean fire;
                    long count = TimerConsumer.this.counter.incrementAndGet();
                    boolean bl = fire = TimerConsumer.this.endpoint.getRepeatCount() <= 0L || count <= TimerConsumer.this.endpoint.getRepeatCount();
                    if (fire) {
                        TimerConsumer.this.sendTimerExchange(count);
                    } else {
                        LOG.debug("Cancelling {} timer as repeat count limit reached after {} counts.", (Object)TimerConsumer.this.endpoint.getTimerName(), (Object)TimerConsumer.this.endpoint.getRepeatCount());
                        this.cancel();
                    }
                }
            };
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.endpoint.getDelay() >= 0L) {
            if (this.task != null && !this.configured && this.endpoint.getCamelContext().getStatus().isStarted()) {
                Timer timer = this.endpoint.getTimer(this);
                this.configureTask(this.task, timer);
            }
        } else {
            this.executorService = this.endpoint.getCamelContext().getExecutorServiceManager().newSingleThreadExecutor(this, this.endpoint.getEndpointUri());
            this.executorService.execute(() -> {
                this.polling = true;
                try {
                    long count = this.counter.incrementAndGet();
                    while ((this.endpoint.getRepeatCount() <= 0L || count <= this.endpoint.getRepeatCount()) && this.isRunAllowed()) {
                        this.sendTimerExchange(count);
                        count = this.counter.incrementAndGet();
                    }
                }
                finally {
                    this.polling = false;
                }
            });
        }
    }

    @Override
    protected void doStop() throws Exception {
        if (this.task != null) {
            this.task.cancel();
        }
        this.task = null;
        this.configured = false;
        this.endpoint.removeTimer(this);
        if (this.executorService != null) {
            this.endpoint.getCamelContext().getExecutorServiceManager().shutdown(this.executorService);
            this.executorService = null;
        }
        super.doStop();
    }

    @Override
    public void onCamelContextStarted(CamelContext context, boolean alreadyStarted) throws Exception {
        if (this.task != null && !this.configured) {
            Timer timer = this.endpoint.getTimer(this);
            this.configureTask(this.task, timer);
        }
    }

    protected boolean isTaskRunAllowed() {
        return this.isStarted();
    }

    protected void configureTask(TimerTask task, Timer timer) {
        if (this.endpoint.isFixedRate()) {
            if (this.endpoint.getTime() != null) {
                timer.scheduleAtFixedRate(task, this.endpoint.getTime(), this.endpoint.getPeriod());
            } else {
                timer.scheduleAtFixedRate(task, this.endpoint.getDelay(), this.endpoint.getPeriod());
            }
        } else if (this.endpoint.getTime() != null) {
            if (this.endpoint.getPeriod() > 0L) {
                timer.schedule(task, this.endpoint.getTime(), this.endpoint.getPeriod());
            } else {
                timer.schedule(task, this.endpoint.getTime());
            }
        } else if (this.endpoint.getPeriod() > 0L) {
            timer.schedule(task, this.endpoint.getDelay(), this.endpoint.getPeriod());
        } else {
            timer.schedule(task, this.endpoint.getDelay());
        }
        this.configured = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendTimerExchange(long counter) {
        Exchange exchange = this.createExchange(false);
        if (this.endpoint.isIncludeMetadata()) {
            exchange.setProperty("CamelTimerCounter", (Object)counter);
            exchange.setProperty("CamelTimerName", (Object)this.endpoint.getTimerName());
            if (this.endpoint.getTime() != null) {
                exchange.setProperty("CamelTimerTime", (Object)this.endpoint.getTime());
            }
            exchange.setProperty("CamelTimerPeriod", (Object)this.endpoint.getPeriod());
            Date now = new Date();
            exchange.setProperty("CamelTimerFiredTime", (Object)now);
            exchange.getIn().setHeader("CamelTimerFiredTime", now);
            exchange.getIn().setHeader("CamelMessageTimestamp", now.getTime());
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Timer {} is firing #{} count", (Object)this.endpoint.getTimerName(), (Object)counter);
        }
        if (!this.endpoint.isSynchronous()) {
            AsyncCallback cb = this.defaultConsumerCallback(exchange, false);
            this.getAsyncProcessor().process(exchange, cb);
        } else {
            try {
                this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                exchange.setException(e);
            }
            try {
                if (exchange.getException() != null) {
                    this.getExceptionHandler().handleException("Error processing exchange", exchange, exchange.getException());
                }
            }
            finally {
                this.releaseExchange(exchange, false);
            }
        }
    }
}

