/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.EnumMap;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.TypeConverter;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeAware;
import org.apache.camel.trait.message.MessageTrait;

public abstract class MessageSupport
implements Message,
CamelContextAware,
DataTypeAware {
    protected CamelContext camelContext;
    protected TypeConverter typeConverter;
    private Exchange exchange;
    private Object body;
    private String messageId;
    private long messageTimestamp;
    private final EnumMap<MessageTrait, Object> traits = new EnumMap(MessageTrait.class);

    @Override
    public void reset() {
        this.body = null;
        this.messageId = null;
        this.traits.clear();
    }

    public String toString() {
        if (this.messageId != null) {
            return "Message[" + this.messageId + "]";
        }
        return "Message";
    }

    @Override
    public Object getBody() {
        if (this.body == null) {
            this.body = this.createBody();
        }
        return this.body;
    }

    @Override
    public <T> T getBody(Class<T> type) {
        return this.getBody(type, this.getBody());
    }

    @Override
    public Object getMandatoryBody() throws InvalidPayloadException {
        Object answer = this.getBody();
        if (answer == null) {
            throw new InvalidPayloadException(this.getExchange(), Object.class, this);
        }
        return answer;
    }

    protected <T> T getBody(Class<T> type, Object body) {
        if (type.isInstance(body)) {
            return (T)body;
        }
        Exchange e = this.getExchange();
        if (e != null) {
            T answer = this.typeConverter.convertTo(type, e, body);
            if (answer != null) {
                return answer;
            }
            answer = this.typeConverter.tryConvertTo(type, e, this);
            if (answer != null) {
                return answer;
            }
        }
        return null;
    }

    @Override
    public <T> T getMandatoryBody(Class<T> type) throws InvalidPayloadException {
        if (type.isInstance(this.body)) {
            return (T)this.body;
        }
        Exchange e = this.getExchange();
        if (e != null) {
            try {
                return this.typeConverter.mandatoryConvertTo(type, e, this.getBody());
            }
            catch (Exception cause) {
                throw new InvalidPayloadException(e, type, this, cause);
            }
        }
        throw new InvalidPayloadException(e, type, this);
    }

    @Override
    public void setBody(Object body) {
        this.body = body;
        if (body != null && this.camelContext != null && this.camelContext.isUseDataType().booleanValue()) {
            this.setPayloadForTrait(MessageTrait.DATA_AWARE, new DataType(body.getClass()));
        }
    }

    @Override
    public <T> void setBody(Object value, Class<T> type) {
        T v;
        Exchange e = this.getExchange();
        if (e != null && (v = this.typeConverter.convertTo(type, e, value)) != null) {
            value = v;
        }
        this.setBody(value);
    }

    @Override
    public void setBody(Object body, DataType type) {
        this.body = body;
        this.setPayloadForTrait(MessageTrait.DATA_AWARE, type);
    }

    @Override
    public DataType getDataType() {
        Object payload = this.getPayloadForTrait(MessageTrait.DATA_AWARE);
        return (DataType)payload;
    }

    @Override
    public void setDataType(DataType type) {
        this.setPayloadForTrait(MessageTrait.DATA_AWARE, type);
    }

    @Override
    public boolean hasDataType() {
        return this.hasTrait(MessageTrait.DATA_AWARE);
    }

    @Override
    public Message copy() {
        Message answer = this.newInstance();
        answer.copyFrom(this);
        return answer;
    }

    @Override
    public void copyFrom(Message that) {
        if (that == this) {
            return;
        }
        this.copyFromWithNewBody(that, that.getBody());
        if (that.hasTrait(MessageTrait.DATA_AWARE)) {
            this.setPayloadForTrait(MessageTrait.DATA_AWARE, that.getPayloadForTrait(MessageTrait.DATA_AWARE));
        }
    }

    @Override
    public void copyFromWithNewBody(Message that, Object newBody) {
        if (that == this) {
            return;
        }
        if (this.getExchange() == null) {
            this.setExchange(that.getExchange());
        }
        if (that.hasMessageId()) {
            this.setMessageId(that.getMessageId());
        }
        this.setBody(newBody);
        if (!this.sameHeaders(that)) {
            if (this.hasHeaders()) {
                this.getHeaders().clear();
            }
            if (that.hasHeaders()) {
                this.getHeaders().putAll(that.getHeaders());
            }
        }
    }

    private boolean sameHeaders(Message that) {
        return this.hasHeaders() && that.hasHeaders() && this.getHeaders() == that.getHeaders();
    }

    @Override
    public Exchange getExchange() {
        return this.exchange;
    }

    public void setExchange(Exchange exchange) {
        this.exchange = exchange;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.typeConverter = camelContext.getTypeConverter();
    }

    public abstract Message newInstance();

    protected Object createBody() {
        return null;
    }

    @Override
    public String getMessageId() {
        if (this.messageId == null) {
            this.messageId = this.createMessageId();
        }
        return this.messageId;
    }

    @Override
    public long getMessageTimestamp() {
        if (this.messageTimestamp == 0L) {
            this.messageTimestamp = this.getHeader("CamelMessageTimestamp", -1L, Long.TYPE);
        }
        return this.messageTimestamp <= 0L ? 0L : this.messageTimestamp;
    }

    @Override
    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    @Override
    public boolean hasMessageId() {
        return this.messageId != null;
    }

    protected String createMessageId() {
        if (this.exchange != null) {
            return this.exchange.getExchangeId();
        }
        return null;
    }

    @Override
    public boolean hasTrait(MessageTrait trait) {
        return this.traits.containsKey((Object)trait);
    }

    @Override
    public Object getPayloadForTrait(MessageTrait trait) {
        return this.traits.get((Object)trait);
    }

    @Override
    public void setPayloadForTrait(MessageTrait trait, Object object) {
        this.traits.put(trait, object);
    }
}

