/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.base;

import com.twilio.Twilio;
import com.twilio.base.Page;
import com.twilio.base.Resource;
import com.twilio.base.ResourceSet;
import com.twilio.http.TwilioRestClient;
import java.util.concurrent.CompletableFuture;

public abstract class Reader<T extends Resource> {
    private Integer pageSize;
    private Long limit;

    public ResourceSet<T> read() {
        return this.read(Twilio.getRestClient());
    }

    public abstract ResourceSet<T> read(TwilioRestClient var1);

    public CompletableFuture<ResourceSet<T>> readAsync() {
        return this.readAsync(Twilio.getRestClient());
    }

    public CompletableFuture<ResourceSet<T>> readAsync(TwilioRestClient client) {
        return CompletableFuture.supplyAsync(() -> this.read(client), Twilio.getExecutorService());
    }

    public Page<T> firstPage() {
        return this.firstPage(Twilio.getRestClient());
    }

    public abstract Page<T> firstPage(TwilioRestClient var1);

    public Page<T> getPage(String targetUrl) {
        return this.getPage(targetUrl, Twilio.getRestClient());
    }

    public abstract Page<T> getPage(String var1, TwilioRestClient var2);

    public Page<T> nextPage(Page<T> page) {
        return this.nextPage(page, Twilio.getRestClient());
    }

    public abstract Page<T> nextPage(Page<T> var1, TwilioRestClient var2);

    public Page<T> previousPage(Page<T> page) {
        return this.previousPage(page, Twilio.getRestClient());
    }

    public abstract Page<T> previousPage(Page<T> var1, TwilioRestClient var2);

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Reader<T> pageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public Long getLimit() {
        return this.limit;
    }

    public Reader<T> limit(long limit) {
        this.limit = limit;
        if (this.pageSize == null) {
            this.pageSize = this.limit.intValue();
        }
        return this;
    }
}

