/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.http.bearertoken;

import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.twilio.http.Response;
import com.twilio.http.bearertoken.BearerTokenHttpClient;
import com.twilio.http.bearertoken.BearerTokenNetworkHttpClient;
import com.twilio.http.bearertoken.BearerTokenRequest;
import com.twilio.http.bearertoken.TokenManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BearerTokenTwilioRestClient {
    public static final int HTTP_STATUS_CODE_CREATED = 201;
    public static final int HTTP_STATUS_CODE_NO_CONTENT = 204;
    public static final int HTTP_STATUS_CODE_OK = 200;
    public static final Predicate<Integer> SUCCESS = i -> i != null && i >= 200 && i < 400;
    private final ObjectMapper objectMapper;
    private String accessToken;
    private final String region;
    private final String edge;
    private final BearerTokenHttpClient httpClient;
    private final List<String> userAgentExtensions;
    private final TokenManager tokenManager;
    private static final Logger logger = LoggerFactory.getLogger(BearerTokenTwilioRestClient.class);

    private BearerTokenTwilioRestClient(Builder b) {
        this.region = b.region;
        this.edge = b.edge;
        this.httpClient = b.httpClient;
        this.objectMapper = new ObjectMapper();
        this.userAgentExtensions = b.userAgentExtensions;
        this.tokenManager = b.tokenManager;
        this.objectMapper.registerModule(new JavaTimeModule());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Response request(BearerTokenRequest request) {
        if (this.accessToken == null || this.accessToken.isEmpty() || this.isTokenExpired(this.accessToken)) {
            Class<BearerTokenTwilioRestClient> clazz = BearerTokenTwilioRestClient.class;
            // MONITORENTER : com.twilio.http.bearertoken.BearerTokenTwilioRestClient.class
            if (this.accessToken == null || this.accessToken.isEmpty() || this.isTokenExpired(this.accessToken)) {
                this.accessToken = this.tokenManager.fetchAccessToken();
            }
            // MONITOREXIT : clazz
        }
        request.setAuth(this.accessToken);
        if (this.region != null) {
            request.setRegion(this.region);
        }
        if (this.edge != null) {
            request.setEdge(this.edge);
        }
        if (this.userAgentExtensions != null && !this.userAgentExtensions.isEmpty()) {
            request.setUserAgentExtensions(this.userAgentExtensions);
        }
        this.logRequest(request);
        Response response = this.httpClient.reliableRequest(request);
        if (response == null) return response;
        int statusCode = response.getStatusCode();
        if (statusCode == 401) {
            this.accessToken = this.tokenManager.fetchAccessToken();
            request.setAuth(this.accessToken);
            response = this.httpClient.reliableRequest(request);
        }
        if (!logger.isDebugEnabled()) return response;
        logger.debug("status code: {}", (Object)statusCode);
        Header[] responseHeaders = response.getHeaders();
        logger.debug("response headers:");
        int i = 0;
        while (i < responseHeaders.length) {
            logger.debug("responseHeader: {}", (Object)responseHeaders[i]);
            ++i;
        }
        return response;
    }

    public boolean isTokenExpired(String token) {
        DecodedJWT jwt = JWT.decode(token);
        Date expiresAt = jwt.getExpiresAt();
        long bufferMilliseconds = 30000L;
        Date bufferExpiresAt = new Date(expiresAt.getTime() - bufferMilliseconds);
        return bufferExpiresAt.before(new Date());
    }

    public void logRequest(BearerTokenRequest request) {
        if (logger.isDebugEnabled()) {
            logger.debug("-- BEGIN Twilio API BearerTokenRequest --");
            logger.debug("request method: " + (Object)((Object)request.getMethod()));
            logger.debug("request URL: " + request.constructURL().toString());
            Map<String, List<String>> queryParams = request.getQueryParams();
            Map<String, List<String>> headerParams = request.getHeaderParams();
            if (queryParams != null && !queryParams.isEmpty()) {
                logger.debug("query parameters: " + queryParams);
            }
            if (headerParams != null && !headerParams.isEmpty()) {
                logger.debug("header parameters: ");
                for (String key : headerParams.keySet()) {
                    if (key.toLowerCase().contains("authorization")) continue;
                    logger.debug(key + ": " + headerParams.get(key));
                }
            }
            logger.debug("-- END Twilio API BearerTokenRequest --");
        }
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public String getRegion() {
        return this.region;
    }

    public String getEdge() {
        return this.edge;
    }

    public BearerTokenHttpClient getHttpClient() {
        return this.httpClient;
    }

    public List<String> getUserAgentExtensions() {
        return this.userAgentExtensions;
    }

    public static class Builder {
        private String region = System.getenv("TWILIO_REGION");
        private String edge = System.getenv("TWILIO_EDGE");
        private BearerTokenHttpClient httpClient;
        private List<String> userAgentExtensions = new ArrayList<String>();
        private TokenManager tokenManager;

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        public Builder edge(String edge) {
            this.edge = edge;
            return this;
        }

        public Builder tokenManager(TokenManager tokenManager) {
            this.tokenManager = tokenManager;
            return this;
        }

        public Builder httpClient(BearerTokenHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder userAgentExtensions(List<String> userAgentExtensions) {
            if (userAgentExtensions != null && !userAgentExtensions.isEmpty()) {
                this.userAgentExtensions = new ArrayList<String>(userAgentExtensions);
            }
            return this;
        }

        public BearerTokenTwilioRestClient build() {
            if (this.httpClient == null) {
                this.httpClient = new BearerTokenNetworkHttpClient();
            }
            return new BearerTokenTwilioRestClient(this);
        }
    }
}

