/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.http.bearertoken;

import com.twilio.exception.ApiException;
import com.twilio.http.bearertoken.TokenManager;
import com.twilio.rest.previewiam.v1.Token;
import com.twilio.rest.previewiam.v1.TokenCreator;

public class OrgsTokenManager
implements TokenManager {
    private final String grantType;
    private final String clientId;
    private final String clientSecret;
    private String code;
    private String redirectUri;
    private String audience;
    private String refreshToken;
    private String scope;

    public OrgsTokenManager(String grantType, String clientId, String clientSecret) {
        this.grantType = grantType;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public OrgsTokenManager(String grantType, String clientId, String clientSecret, String code, String redirectUri, String audience, String refreshToken, String scope) {
        this.grantType = grantType;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.code = code;
        this.redirectUri = redirectUri;
        this.audience = audience;
        this.refreshToken = refreshToken;
        this.scope = scope;
    }

    @Override
    public synchronized String fetchAccessToken() {
        Token token;
        TokenCreator tokenCreator = Token.creator(this.grantType, this.clientId).setClientSecret(this.clientSecret);
        if (this.code != null) {
            tokenCreator.setCode(this.code);
        }
        if (this.redirectUri != null) {
            tokenCreator.setRedirectUri(this.redirectUri);
        }
        if (this.audience != null) {
            tokenCreator.setAudience(this.audience);
        }
        if (this.refreshToken != null) {
            tokenCreator.setRefreshToken(this.refreshToken);
        }
        if (this.scope != null) {
            tokenCreator.setScope(this.scope);
        }
        try {
            token = (Token)tokenCreator.create();
            if (token == null || token.getAccessToken() == null) {
                throw new ApiException("Token creation failed");
            }
        }
        catch (Exception e) {
            throw new ApiException("Token creation failed");
        }
        return token.getAccessToken();
    }
}

