/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.Conference;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class ConferenceReader
extends Reader<Conference> {
    private String pathAccountSid;
    private LocalDate dateCreated;
    private LocalDate dateCreatedBefore;
    private LocalDate dateCreatedAfter;
    private LocalDate dateUpdated;
    private LocalDate dateUpdatedBefore;
    private LocalDate dateUpdatedAfter;
    private String friendlyName;
    private Conference.Status status;
    private Integer pageSize;

    public ConferenceReader() {
    }

    public ConferenceReader(String pathAccountSid) {
        this.pathAccountSid = pathAccountSid;
    }

    public ConferenceReader setDateCreated(LocalDate dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    public ConferenceReader setDateCreatedBefore(LocalDate dateCreatedBefore) {
        this.dateCreatedBefore = dateCreatedBefore;
        return this;
    }

    public ConferenceReader setDateCreatedAfter(LocalDate dateCreatedAfter) {
        this.dateCreatedAfter = dateCreatedAfter;
        return this;
    }

    public ConferenceReader setDateUpdated(LocalDate dateUpdated) {
        this.dateUpdated = dateUpdated;
        return this;
    }

    public ConferenceReader setDateUpdatedBefore(LocalDate dateUpdatedBefore) {
        this.dateUpdatedBefore = dateUpdatedBefore;
        return this;
    }

    public ConferenceReader setDateUpdatedAfter(LocalDate dateUpdatedAfter) {
        this.dateUpdatedAfter = dateUpdatedAfter;
        return this;
    }

    public ConferenceReader setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public ConferenceReader setStatus(Conference.Status status) {
        this.status = status;
        return this;
    }

    public ConferenceReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<Conference> read(TwilioRestClient client) {
        return new ResourceSet<Conference>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Conference> firstPage(TwilioRestClient client) {
        String path = "/2010-04-01/Accounts/{AccountSid}/Conferences.json";
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        path = path.replace("{AccountSid}", this.pathAccountSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<Conference> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Conference read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("conferences", response.getContent(), Conference.class, client.getObjectMapper());
    }

    @Override
    public Page<Conference> previousPage(Page<Conference> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.API.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Conference> nextPage(Page<Conference> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.API.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Conference> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.dateCreated != null) {
            request.addQueryParam("DateCreated", this.dateCreated.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        } else if (this.dateCreatedAfter != null || this.dateCreatedBefore != null) {
            request.addQueryDateRange("DateCreated", this.dateCreatedAfter, this.dateCreatedBefore);
        }
        if (this.dateUpdated != null) {
            request.addQueryParam("DateUpdated", this.dateUpdated.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        } else if (this.dateUpdatedAfter != null || this.dateUpdatedBefore != null) {
            request.addQueryDateRange("DateUpdated", this.dateUpdatedAfter, this.dateUpdatedBefore);
        }
        if (this.friendlyName != null) {
            request.addQueryParam("FriendlyName", this.friendlyName);
        }
        if (this.status != null) {
            request.addQueryParam("Status", this.status.toString());
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

