/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.Notification;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class NotificationReader
extends Reader<Notification> {
    private String pathAccountSid;
    private Integer log;
    private LocalDate messageDate;
    private LocalDate messageDateBefore;
    private LocalDate messageDateAfter;
    private Integer pageSize;

    public NotificationReader() {
    }

    public NotificationReader(String pathAccountSid) {
        this.pathAccountSid = pathAccountSid;
    }

    public NotificationReader setLog(Integer log) {
        this.log = log;
        return this;
    }

    public NotificationReader setMessageDate(LocalDate messageDate) {
        this.messageDate = messageDate;
        return this;
    }

    public NotificationReader setMessageDateBefore(LocalDate messageDateBefore) {
        this.messageDateBefore = messageDateBefore;
        return this;
    }

    public NotificationReader setMessageDateAfter(LocalDate messageDateAfter) {
        this.messageDateAfter = messageDateAfter;
        return this;
    }

    public NotificationReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<Notification> read(TwilioRestClient client) {
        return new ResourceSet<Notification>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Notification> firstPage(TwilioRestClient client) {
        String path = "/2010-04-01/Accounts/{AccountSid}/Notifications.json";
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        path = path.replace("{AccountSid}", this.pathAccountSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<Notification> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Notification read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("notifications", response.getContent(), Notification.class, client.getObjectMapper());
    }

    @Override
    public Page<Notification> previousPage(Page<Notification> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.API.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Notification> nextPage(Page<Notification> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.API.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Notification> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.log != null) {
            request.addQueryParam("Log", this.log.toString());
        }
        if (this.messageDate != null) {
            request.addQueryParam("MessageDate", this.messageDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        } else if (this.messageDateAfter != null || this.messageDateBefore != null) {
            request.addQueryDateRange("MessageDate", this.messageDateAfter, this.messageDateBefore);
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

