/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.address;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.address.DependentPhoneNumber;

public class DependentPhoneNumberReader
extends Reader<DependentPhoneNumber> {
    private String pathAddressSid;
    private String pathAccountSid;
    private Integer pageSize;

    public DependentPhoneNumberReader(String pathAddressSid) {
        this.pathAddressSid = pathAddressSid;
    }

    public DependentPhoneNumberReader(String pathAccountSid, String pathAddressSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathAddressSid = pathAddressSid;
    }

    public DependentPhoneNumberReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<DependentPhoneNumber> read(TwilioRestClient client) {
        return new ResourceSet<DependentPhoneNumber>(this, client, this.firstPage(client));
    }

    @Override
    public Page<DependentPhoneNumber> firstPage(TwilioRestClient client) {
        String path = "/2010-04-01/Accounts/{AccountSid}/Addresses/{AddressSid}/DependentPhoneNumbers.json";
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        path = path.replace("{AccountSid}", this.pathAccountSid.toString());
        path = path.replace("{AddressSid}", this.pathAddressSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<DependentPhoneNumber> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("DependentPhoneNumber read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("dependent_phone_numbers", response.getContent(), DependentPhoneNumber.class, client.getObjectMapper());
    }

    @Override
    public Page<DependentPhoneNumber> previousPage(Page<DependentPhoneNumber> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.API.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<DependentPhoneNumber> nextPage(Page<DependentPhoneNumber> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.API.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<DependentPhoneNumber> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

