/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.call;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.call.UserDefinedMessageSubscriptionCreator;
import com.twilio.rest.api.v2010.account.call.UserDefinedMessageSubscriptionDeleter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class UserDefinedMessageSubscription
extends Resource {
    private static final long serialVersionUID = 182880491726748L;
    private final String accountSid;
    private final String callSid;
    private final String sid;
    private final ZonedDateTime dateCreated;
    private final String uri;

    public static UserDefinedMessageSubscriptionCreator creator(String pathCallSid, URI callback) {
        return new UserDefinedMessageSubscriptionCreator(pathCallSid, callback);
    }

    public static UserDefinedMessageSubscriptionCreator creator(String pathAccountSid, String pathCallSid, URI callback) {
        return new UserDefinedMessageSubscriptionCreator(pathAccountSid, pathCallSid, callback);
    }

    public static UserDefinedMessageSubscriptionDeleter deleter(String pathCallSid, String pathSid) {
        return new UserDefinedMessageSubscriptionDeleter(pathCallSid, pathSid);
    }

    public static UserDefinedMessageSubscriptionDeleter deleter(String pathAccountSid, String pathCallSid, String pathSid) {
        return new UserDefinedMessageSubscriptionDeleter(pathAccountSid, pathCallSid, pathSid);
    }

    public static UserDefinedMessageSubscription fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, UserDefinedMessageSubscription.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static UserDefinedMessageSubscription fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, UserDefinedMessageSubscription.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private UserDefinedMessageSubscription(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="call_sid") String callSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="uri") String uri) {
        this.accountSid = accountSid;
        this.callSid = callSid;
        this.sid = sid;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.uri = uri;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getCallSid() {
        return this.callSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final String getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserDefinedMessageSubscription other = (UserDefinedMessageSubscription)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.callSid, other.callSid) && Objects.equals(this.sid, other.sid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.uri, other.uri);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.callSid, this.sid, this.dateCreated, this.uri);
    }

    public String toString() {
        return "UserDefinedMessageSubscription(accountSid=" + this.getAccountSid() + ", callSid=" + this.getCallSid() + ", sid=" + this.getSid() + ", dateCreated=" + this.getDateCreated() + ", uri=" + this.getUri() + ")";
    }
}

