/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.call;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.call.UserDefinedMessageSubscription;
import java.net.URI;

public class UserDefinedMessageSubscriptionCreator
extends Creator<UserDefinedMessageSubscription> {
    private String pathCallSid;
    private URI callback;
    private String pathAccountSid;
    private String idempotencyKey;
    private HttpMethod method;

    public UserDefinedMessageSubscriptionCreator(String pathCallSid, URI callback) {
        this.pathCallSid = pathCallSid;
        this.callback = callback;
    }

    public UserDefinedMessageSubscriptionCreator(String pathAccountSid, String pathCallSid, URI callback) {
        this.pathAccountSid = pathAccountSid;
        this.pathCallSid = pathCallSid;
        this.callback = callback;
    }

    public UserDefinedMessageSubscriptionCreator setCallback(URI callback) {
        this.callback = callback;
        return this;
    }

    public UserDefinedMessageSubscriptionCreator setCallback(String callback) {
        return this.setCallback(Promoter.uriFromString(callback));
    }

    public UserDefinedMessageSubscriptionCreator setIdempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
        return this;
    }

    public UserDefinedMessageSubscriptionCreator setMethod(HttpMethod method) {
        this.method = method;
        return this;
    }

    @Override
    public UserDefinedMessageSubscription create(TwilioRestClient client) {
        String path = "/2010-04-01/Accounts/{AccountSid}/Calls/{CallSid}/UserDefinedMessageSubscriptions.json";
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        path = path.replace("{AccountSid}", this.pathAccountSid.toString());
        path = path.replace("{CallSid}", this.pathCallSid.toString());
        path = path.replace("{Callback}", this.callback.toString());
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("UserDefinedMessageSubscription creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return UserDefinedMessageSubscription.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.callback != null) {
            request.addPostParam("Callback", this.callback.toString());
        }
        if (this.idempotencyKey != null) {
            request.addPostParam("IdempotencyKey", this.idempotencyKey);
        }
        if (this.method != null) {
            request.addPostParam("Method", this.method.toString());
        }
    }
}

