/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.conference;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.conference.Participant;
import com.twilio.type.Endpoint;
import java.net.URI;
import java.util.List;

public class ParticipantCreator
extends Creator<Participant> {
    private String pathConferenceSid;
    private Endpoint from;
    private Endpoint to;
    private String pathAccountSid;
    private URI statusCallback;
    private HttpMethod statusCallbackMethod;
    private List<String> statusCallbackEvent;
    private String label;
    private Integer timeout;
    private Boolean record;
    private Boolean muted;
    private String beep;
    private Boolean startConferenceOnEnter;
    private Boolean endConferenceOnExit;
    private URI waitUrl;
    private HttpMethod waitMethod;
    private Boolean earlyMedia;
    private Integer maxParticipants;
    private String conferenceRecord;
    private String conferenceTrim;
    private URI conferenceStatusCallback;
    private HttpMethod conferenceStatusCallbackMethod;
    private List<String> conferenceStatusCallbackEvent;
    private String recordingChannels;
    private URI recordingStatusCallback;
    private HttpMethod recordingStatusCallbackMethod;
    private String sipAuthUsername;
    private String sipAuthPassword;
    private String region;
    private URI conferenceRecordingStatusCallback;
    private HttpMethod conferenceRecordingStatusCallbackMethod;
    private List<String> recordingStatusCallbackEvent;
    private List<String> conferenceRecordingStatusCallbackEvent;
    private Boolean coaching;
    private String callSidToCoach;
    private String jitterBufferSize;
    private String byoc;
    private String callerId;
    private String callReason;
    private String recordingTrack;
    private Integer timeLimit;
    private String machineDetection;
    private Integer machineDetectionTimeout;
    private Integer machineDetectionSpeechThreshold;
    private Integer machineDetectionSpeechEndThreshold;
    private Integer machineDetectionSilenceTimeout;
    private URI amdStatusCallback;
    private HttpMethod amdStatusCallbackMethod;
    private String trim;
    private String callToken;

    public ParticipantCreator(String pathConferenceSid, Endpoint from, Endpoint to) {
        this.pathConferenceSid = pathConferenceSid;
        this.from = from;
        this.to = to;
    }

    public ParticipantCreator(String pathAccountSid, String pathConferenceSid, Endpoint from, Endpoint to) {
        this.pathAccountSid = pathAccountSid;
        this.pathConferenceSid = pathConferenceSid;
        this.from = from;
        this.to = to;
    }

    public ParticipantCreator setFrom(Endpoint from) {
        this.from = from;
        return this;
    }

    public ParticipantCreator setTo(Endpoint to) {
        this.to = to;
        return this;
    }

    public ParticipantCreator setStatusCallback(URI statusCallback) {
        this.statusCallback = statusCallback;
        return this;
    }

    public ParticipantCreator setStatusCallback(String statusCallback) {
        return this.setStatusCallback(Promoter.uriFromString(statusCallback));
    }

    public ParticipantCreator setStatusCallbackMethod(HttpMethod statusCallbackMethod) {
        this.statusCallbackMethod = statusCallbackMethod;
        return this;
    }

    public ParticipantCreator setStatusCallbackEvent(List<String> statusCallbackEvent) {
        this.statusCallbackEvent = statusCallbackEvent;
        return this;
    }

    public ParticipantCreator setStatusCallbackEvent(String statusCallbackEvent) {
        return this.setStatusCallbackEvent(Promoter.listOfOne(statusCallbackEvent));
    }

    public ParticipantCreator setLabel(String label) {
        this.label = label;
        return this;
    }

    public ParticipantCreator setTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    public ParticipantCreator setRecord(Boolean record) {
        this.record = record;
        return this;
    }

    public ParticipantCreator setMuted(Boolean muted) {
        this.muted = muted;
        return this;
    }

    public ParticipantCreator setBeep(String beep) {
        this.beep = beep;
        return this;
    }

    public ParticipantCreator setStartConferenceOnEnter(Boolean startConferenceOnEnter) {
        this.startConferenceOnEnter = startConferenceOnEnter;
        return this;
    }

    public ParticipantCreator setEndConferenceOnExit(Boolean endConferenceOnExit) {
        this.endConferenceOnExit = endConferenceOnExit;
        return this;
    }

    public ParticipantCreator setWaitUrl(URI waitUrl) {
        this.waitUrl = waitUrl;
        return this;
    }

    public ParticipantCreator setWaitUrl(String waitUrl) {
        return this.setWaitUrl(Promoter.uriFromString(waitUrl));
    }

    public ParticipantCreator setWaitMethod(HttpMethod waitMethod) {
        this.waitMethod = waitMethod;
        return this;
    }

    public ParticipantCreator setEarlyMedia(Boolean earlyMedia) {
        this.earlyMedia = earlyMedia;
        return this;
    }

    public ParticipantCreator setMaxParticipants(Integer maxParticipants) {
        this.maxParticipants = maxParticipants;
        return this;
    }

    public ParticipantCreator setConferenceRecord(String conferenceRecord) {
        this.conferenceRecord = conferenceRecord;
        return this;
    }

    public ParticipantCreator setConferenceTrim(String conferenceTrim) {
        this.conferenceTrim = conferenceTrim;
        return this;
    }

    public ParticipantCreator setConferenceStatusCallback(URI conferenceStatusCallback) {
        this.conferenceStatusCallback = conferenceStatusCallback;
        return this;
    }

    public ParticipantCreator setConferenceStatusCallback(String conferenceStatusCallback) {
        return this.setConferenceStatusCallback(Promoter.uriFromString(conferenceStatusCallback));
    }

    public ParticipantCreator setConferenceStatusCallbackMethod(HttpMethod conferenceStatusCallbackMethod) {
        this.conferenceStatusCallbackMethod = conferenceStatusCallbackMethod;
        return this;
    }

    public ParticipantCreator setConferenceStatusCallbackEvent(List<String> conferenceStatusCallbackEvent) {
        this.conferenceStatusCallbackEvent = conferenceStatusCallbackEvent;
        return this;
    }

    public ParticipantCreator setConferenceStatusCallbackEvent(String conferenceStatusCallbackEvent) {
        return this.setConferenceStatusCallbackEvent(Promoter.listOfOne(conferenceStatusCallbackEvent));
    }

    public ParticipantCreator setRecordingChannels(String recordingChannels) {
        this.recordingChannels = recordingChannels;
        return this;
    }

    public ParticipantCreator setRecordingStatusCallback(URI recordingStatusCallback) {
        this.recordingStatusCallback = recordingStatusCallback;
        return this;
    }

    public ParticipantCreator setRecordingStatusCallback(String recordingStatusCallback) {
        return this.setRecordingStatusCallback(Promoter.uriFromString(recordingStatusCallback));
    }

    public ParticipantCreator setRecordingStatusCallbackMethod(HttpMethod recordingStatusCallbackMethod) {
        this.recordingStatusCallbackMethod = recordingStatusCallbackMethod;
        return this;
    }

    public ParticipantCreator setSipAuthUsername(String sipAuthUsername) {
        this.sipAuthUsername = sipAuthUsername;
        return this;
    }

    public ParticipantCreator setSipAuthPassword(String sipAuthPassword) {
        this.sipAuthPassword = sipAuthPassword;
        return this;
    }

    public ParticipantCreator setRegion(String region) {
        this.region = region;
        return this;
    }

    public ParticipantCreator setConferenceRecordingStatusCallback(URI conferenceRecordingStatusCallback) {
        this.conferenceRecordingStatusCallback = conferenceRecordingStatusCallback;
        return this;
    }

    public ParticipantCreator setConferenceRecordingStatusCallback(String conferenceRecordingStatusCallback) {
        return this.setConferenceRecordingStatusCallback(Promoter.uriFromString(conferenceRecordingStatusCallback));
    }

    public ParticipantCreator setConferenceRecordingStatusCallbackMethod(HttpMethod conferenceRecordingStatusCallbackMethod) {
        this.conferenceRecordingStatusCallbackMethod = conferenceRecordingStatusCallbackMethod;
        return this;
    }

    public ParticipantCreator setRecordingStatusCallbackEvent(List<String> recordingStatusCallbackEvent) {
        this.recordingStatusCallbackEvent = recordingStatusCallbackEvent;
        return this;
    }

    public ParticipantCreator setRecordingStatusCallbackEvent(String recordingStatusCallbackEvent) {
        return this.setRecordingStatusCallbackEvent(Promoter.listOfOne(recordingStatusCallbackEvent));
    }

    public ParticipantCreator setConferenceRecordingStatusCallbackEvent(List<String> conferenceRecordingStatusCallbackEvent) {
        this.conferenceRecordingStatusCallbackEvent = conferenceRecordingStatusCallbackEvent;
        return this;
    }

    public ParticipantCreator setConferenceRecordingStatusCallbackEvent(String conferenceRecordingStatusCallbackEvent) {
        return this.setConferenceRecordingStatusCallbackEvent(Promoter.listOfOne(conferenceRecordingStatusCallbackEvent));
    }

    public ParticipantCreator setCoaching(Boolean coaching) {
        this.coaching = coaching;
        return this;
    }

    public ParticipantCreator setCallSidToCoach(String callSidToCoach) {
        this.callSidToCoach = callSidToCoach;
        return this;
    }

    public ParticipantCreator setJitterBufferSize(String jitterBufferSize) {
        this.jitterBufferSize = jitterBufferSize;
        return this;
    }

    public ParticipantCreator setByoc(String byoc) {
        this.byoc = byoc;
        return this;
    }

    public ParticipantCreator setCallerId(String callerId) {
        this.callerId = callerId;
        return this;
    }

    public ParticipantCreator setCallReason(String callReason) {
        this.callReason = callReason;
        return this;
    }

    public ParticipantCreator setRecordingTrack(String recordingTrack) {
        this.recordingTrack = recordingTrack;
        return this;
    }

    public ParticipantCreator setTimeLimit(Integer timeLimit) {
        this.timeLimit = timeLimit;
        return this;
    }

    public ParticipantCreator setMachineDetection(String machineDetection) {
        this.machineDetection = machineDetection;
        return this;
    }

    public ParticipantCreator setMachineDetectionTimeout(Integer machineDetectionTimeout) {
        this.machineDetectionTimeout = machineDetectionTimeout;
        return this;
    }

    public ParticipantCreator setMachineDetectionSpeechThreshold(Integer machineDetectionSpeechThreshold) {
        this.machineDetectionSpeechThreshold = machineDetectionSpeechThreshold;
        return this;
    }

    public ParticipantCreator setMachineDetectionSpeechEndThreshold(Integer machineDetectionSpeechEndThreshold) {
        this.machineDetectionSpeechEndThreshold = machineDetectionSpeechEndThreshold;
        return this;
    }

    public ParticipantCreator setMachineDetectionSilenceTimeout(Integer machineDetectionSilenceTimeout) {
        this.machineDetectionSilenceTimeout = machineDetectionSilenceTimeout;
        return this;
    }

    public ParticipantCreator setAmdStatusCallback(URI amdStatusCallback) {
        this.amdStatusCallback = amdStatusCallback;
        return this;
    }

    public ParticipantCreator setAmdStatusCallback(String amdStatusCallback) {
        return this.setAmdStatusCallback(Promoter.uriFromString(amdStatusCallback));
    }

    public ParticipantCreator setAmdStatusCallbackMethod(HttpMethod amdStatusCallbackMethod) {
        this.amdStatusCallbackMethod = amdStatusCallbackMethod;
        return this;
    }

    public ParticipantCreator setTrim(String trim) {
        this.trim = trim;
        return this;
    }

    public ParticipantCreator setCallToken(String callToken) {
        this.callToken = callToken;
        return this;
    }

    @Override
    public Participant create(TwilioRestClient client) {
        String path = "/2010-04-01/Accounts/{AccountSid}/Conferences/{ConferenceSid}/Participants.json";
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        path = path.replace("{AccountSid}", this.pathAccountSid.toString());
        path = path.replace("{ConferenceSid}", this.pathConferenceSid.toString());
        path = path.replace("{From}", this.from.toString());
        path = path.replace("{To}", this.to.toString());
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Participant creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Participant.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.from != null) {
            request.addPostParam("From", this.from.toString());
        }
        if (this.to != null) {
            request.addPostParam("To", this.to.toString());
        }
        if (this.statusCallback != null) {
            request.addPostParam("StatusCallback", this.statusCallback.toString());
        }
        if (this.statusCallbackMethod != null) {
            request.addPostParam("StatusCallbackMethod", this.statusCallbackMethod.toString());
        }
        if (this.statusCallbackEvent != null) {
            for (String prop : this.statusCallbackEvent) {
                request.addPostParam("StatusCallbackEvent", prop);
            }
        }
        if (this.label != null) {
            request.addPostParam("Label", this.label);
        }
        if (this.timeout != null) {
            request.addPostParam("Timeout", this.timeout.toString());
        }
        if (this.record != null) {
            request.addPostParam("Record", this.record.toString());
        }
        if (this.muted != null) {
            request.addPostParam("Muted", this.muted.toString());
        }
        if (this.beep != null) {
            request.addPostParam("Beep", this.beep);
        }
        if (this.startConferenceOnEnter != null) {
            request.addPostParam("StartConferenceOnEnter", this.startConferenceOnEnter.toString());
        }
        if (this.endConferenceOnExit != null) {
            request.addPostParam("EndConferenceOnExit", this.endConferenceOnExit.toString());
        }
        if (this.waitUrl != null) {
            request.addPostParam("WaitUrl", this.waitUrl.toString());
        }
        if (this.waitMethod != null) {
            request.addPostParam("WaitMethod", this.waitMethod.toString());
        }
        if (this.earlyMedia != null) {
            request.addPostParam("EarlyMedia", this.earlyMedia.toString());
        }
        if (this.maxParticipants != null) {
            request.addPostParam("MaxParticipants", this.maxParticipants.toString());
        }
        if (this.conferenceRecord != null) {
            request.addPostParam("ConferenceRecord", this.conferenceRecord);
        }
        if (this.conferenceTrim != null) {
            request.addPostParam("ConferenceTrim", this.conferenceTrim);
        }
        if (this.conferenceStatusCallback != null) {
            request.addPostParam("ConferenceStatusCallback", this.conferenceStatusCallback.toString());
        }
        if (this.conferenceStatusCallbackMethod != null) {
            request.addPostParam("ConferenceStatusCallbackMethod", this.conferenceStatusCallbackMethod.toString());
        }
        if (this.conferenceStatusCallbackEvent != null) {
            for (String prop : this.conferenceStatusCallbackEvent) {
                request.addPostParam("ConferenceStatusCallbackEvent", prop);
            }
        }
        if (this.recordingChannels != null) {
            request.addPostParam("RecordingChannels", this.recordingChannels);
        }
        if (this.recordingStatusCallback != null) {
            request.addPostParam("RecordingStatusCallback", this.recordingStatusCallback.toString());
        }
        if (this.recordingStatusCallbackMethod != null) {
            request.addPostParam("RecordingStatusCallbackMethod", this.recordingStatusCallbackMethod.toString());
        }
        if (this.sipAuthUsername != null) {
            request.addPostParam("SipAuthUsername", this.sipAuthUsername);
        }
        if (this.sipAuthPassword != null) {
            request.addPostParam("SipAuthPassword", this.sipAuthPassword);
        }
        if (this.region != null) {
            request.addPostParam("Region", this.region);
        }
        if (this.conferenceRecordingStatusCallback != null) {
            request.addPostParam("ConferenceRecordingStatusCallback", this.conferenceRecordingStatusCallback.toString());
        }
        if (this.conferenceRecordingStatusCallbackMethod != null) {
            request.addPostParam("ConferenceRecordingStatusCallbackMethod", this.conferenceRecordingStatusCallbackMethod.toString());
        }
        if (this.recordingStatusCallbackEvent != null) {
            for (String prop : this.recordingStatusCallbackEvent) {
                request.addPostParam("RecordingStatusCallbackEvent", prop);
            }
        }
        if (this.conferenceRecordingStatusCallbackEvent != null) {
            for (String prop : this.conferenceRecordingStatusCallbackEvent) {
                request.addPostParam("ConferenceRecordingStatusCallbackEvent", prop);
            }
        }
        if (this.coaching != null) {
            request.addPostParam("Coaching", this.coaching.toString());
        }
        if (this.callSidToCoach != null) {
            request.addPostParam("CallSidToCoach", this.callSidToCoach);
        }
        if (this.jitterBufferSize != null) {
            request.addPostParam("JitterBufferSize", this.jitterBufferSize);
        }
        if (this.byoc != null) {
            request.addPostParam("Byoc", this.byoc);
        }
        if (this.callerId != null) {
            request.addPostParam("CallerId", this.callerId);
        }
        if (this.callReason != null) {
            request.addPostParam("CallReason", this.callReason);
        }
        if (this.recordingTrack != null) {
            request.addPostParam("RecordingTrack", this.recordingTrack);
        }
        if (this.timeLimit != null) {
            request.addPostParam("TimeLimit", this.timeLimit.toString());
        }
        if (this.machineDetection != null) {
            request.addPostParam("MachineDetection", this.machineDetection);
        }
        if (this.machineDetectionTimeout != null) {
            request.addPostParam("MachineDetectionTimeout", this.machineDetectionTimeout.toString());
        }
        if (this.machineDetectionSpeechThreshold != null) {
            request.addPostParam("MachineDetectionSpeechThreshold", this.machineDetectionSpeechThreshold.toString());
        }
        if (this.machineDetectionSpeechEndThreshold != null) {
            request.addPostParam("MachineDetectionSpeechEndThreshold", this.machineDetectionSpeechEndThreshold.toString());
        }
        if (this.machineDetectionSilenceTimeout != null) {
            request.addPostParam("MachineDetectionSilenceTimeout", this.machineDetectionSilenceTimeout.toString());
        }
        if (this.amdStatusCallback != null) {
            request.addPostParam("AmdStatusCallback", this.amdStatusCallback.toString());
        }
        if (this.amdStatusCallbackMethod != null) {
            request.addPostParam("AmdStatusCallbackMethod", this.amdStatusCallbackMethod.toString());
        }
        if (this.trim != null) {
            request.addPostParam("Trim", this.trim);
        }
        if (this.callToken != null) {
            request.addPostParam("CallToken", this.callToken);
        }
    }
}

